<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;
use PDO;

class LogController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_LOGS');
    }

    public function index()
    {
        $actions = array(
            'GENERAL_SETTINGS_UPDATED' => t__('General Settings updated'),
            'SYSTEM_SETTINGS_UPDATED' => t__('System Settings updated'),
            'SEO_SETTINGS_UPDATED' => t__('SEO Settings updated'),
            'SMTP_SETTINGS_UPDATED' => t__('SMTP Settings updated'),
            'WEBHOOK_SETTINGS_UPDATED' => t__('Webhook Settings updated'),
            'API_SETTINGS_UPDATED' => t__('API Settings updated'),
            'LANGUAGE_ADDED' => t__('Language added'),
            'LANGUAGE_UPDATED' => t__('Language updated'),
            'SYSTEM_UPDATED' => t__('LeaderOS updated'),
            'THEME_UPDATED' => t__('Theme updated'),
            'THEME_SETTINGS_UPDATED' => t__('Theme Settings updated'),
            'THEME_HEADER_UPDATED' => t__('Theme Settings updated'),
            'THEME_CSS_UPDATED' => t__('Theme CSS updated'),
            'GAMING_NIGHT_UPDATED' => t__('Gaming Night Settings updated'),
            'MODULES_UPDATED' => t__('Module Settings updated'),
            'DISCORD_SETTINGS_UPDATED' => t__('Module Settings updated'),
            'PARASUT_SETTINGS_UPDATED' => t__('Paraşüt Settings updated'),
            'BIRFATURA_SETTINGS_UPDATED' => t__('BirFatura Settings updated'),
            'PUNISHMENT_SETTINGS_UPDATED' => t__('Punishments Settings updated'),
            'CREDITS_SENT' => t__('Credits sent'),
            'CHEST_ITEM_SENT' => t__('Chest item sent'),
            'USER_CREATED' => t__('User created'),
            'USER_UPDATED' => t__('User updated'),
            "TEBEX_STORE_SETTINGS_UPDATED" => t__("Tebex Store Settings updated"),
        );

        if (isset($_GET["page"])) {
            if (!is_numeric($_GET["page"])) {
                $_GET["page"] = 1;
            }
            $page = intval(get("page"));
        } else {
            $page = 1;
        }

        $visiblePageCount = 5;
        $limit = 50;
				
				$action = null;
				if (isset($_GET["action"])) {
					$action = get("action");
				}

        $itemsCount = db()->query("SELECT count(id) FROM Logs")->fetchColumn();
        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;
        $logs = db()->query("SELECT L.*, A.username, A.realname FROM Logs L INNER JOIN Accounts A ON L.accountID = A.id ORDER BY L.id DESC LIMIT $visibleItemsCount, $limit");

        if (isset($_GET["search"])) {
	        $logs = db()->prepare("SELECT L.*, A.username, A.realname FROM Logs L INNER JOIN Accounts A ON L.accountID = A.id WHERE (A.realname LIKE :search OR A.username LIKE :search) OR L.ip LIKE :search ORDER BY L.id DESC");
	        $logs->execute(array(
		        "search" => '%' . get("search") . '%'
	        ));
        } else if (isset($_GET["action"])) {
	        $logs = db()->prepare("SELECT L.*, A.username, A.realname FROM Logs L INNER JOIN Accounts A ON L.accountID = A.id WHERE L.action = :action ORDER BY L.id DESC");
	        $logs->execute(array(
		        "action" => $action
	        ));
        }
				
        $logs = $logs->fetchAll(PDO::FETCH_ASSOC);

        return view('logs.index', compact('logs', 'actions', 'page', 'visiblePageCount', 'pageCount'));
    }

    public function destroy($id)
    {
        /*abort_perm('SUPER_ADMIN');

        $deleteLogs = db()->prepare("DELETE FROM Logs WHERE id = ?");
        $deleteLogs->execute(array($id));*/

        return back();
    }

    public function destroyAll()
    {
        /*abort_perm('SUPER_ADMIN');

        $deleteLogs = db()->prepare("TRUNCATE TABLE Logs");
        $deleteLogs->execute();*/

        return back();
    }
}