<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;
use Dashboard\Services\ProductService;
use Dashboard\Services\SlugService;
use PDO;

class LotteryController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_LOTTERY');
    }

    public function index()
    {
        $lotteries = db()->query("SELECT * FROM Lotteries ORDER BY id DESC");
        $lotteries = $lotteries->fetchAll();

        return view('lotteries.index', compact('lotteries'));
    }

    public function create()
    {
        $categories = db()->query("SELECT id, name, parentID FROM ProductCategories ORDER BY priority DESC");
        $categories = $categories->fetchAll(PDO::FETCH_ASSOC);

        $products = db()->query("SELECT id, name, categoryID FROM Products ORDER BY priority DESC");
        $products = array_map(function ($product) {
					// Exclude products that have variables
	        $variables = db()->prepare("SELECT V.id FROM ProductVariables PV INNER JOIN StoreVariables V ON PV.variableID = V.id WHERE PV.productID = ?");
	        $variables->execute(array($product["id"]));
					if ($variables->rowCount() > 0) {
						return null;
					}
					
					return $product;
        }, $products->fetchAll(PDO::FETCH_ASSOC));
				$products = array_filter($products);

        $productList = ProductService::buildTree($categories, $products);

        return view('lotteries.create', compact('productList'));
    }

    public function store()
    {
        validate([
            'title' => 'required',
            'priceStatus' => 'required',
            'price' => 'required_if:priceStatus,1',
            'duration' => 'required_if:priceStatus,0',
            'lotteryTitle' => 'required',
            'lotteryChance' => 'required',
            'lotteryColor' => 'required',
            'lotteryAwardType' => 'required',
            'lotteryAward' => 'required',
        ]);

        if (input("priceStatus") == 0) {
            set_input('price', 0);
        } else {
            set_input('duration', 0);
        }
	    
		    $slug = SlugService::preventDuplicate(input("title"), 'Lotteries');

        $insertLotteries = db()->prepare("INSERT INTO Lotteries (title, slug, price, duration) VALUES (?, ?, ?, ?)");
        $insertLotteries->execute(array(input("title"), $slug, input("price"), input("duration")));
        $lotteryID = db()->lastInsertId();

        foreach ($_POST["lotteryChance"] as $key => $value) {
            $_POST["lotteryTitle"][$key] = strip_tags($_POST["lotteryTitle"][$key]);
            $_POST["lotteryChance"][$key] = strip_tags(str_replace('%', '', $_POST["lotteryChance"][$key]));
            $_POST["lotteryColor"][$key] = strip_tags($_POST["lotteryColor"][$key]);
            $_POST["lotteryAwardType"][$key] = strip_tags($_POST["lotteryAwardType"][$key]);
            $_POST["lotteryAward"][$key] = ($_POST["lotteryAward"][$key] != null) ? strip_tags($_POST["lotteryAward"][$key]) : '0';
            $insertLotteryAwards = db()->prepare("INSERT INTO LotteryAwards (lotteryID, title, chance, color, awardType, award) VALUES (?, ?, ?, ?, ?, ?)");
            $insertLotteryAwards->execute(array($lotteryID, $_POST["lotteryTitle"][$key], $_POST["lotteryChance"][$key], $_POST["lotteryColor"][$key], $_POST["lotteryAwardType"][$key], $_POST["lotteryAward"][$key]));
        }

        return back()->flash("success", t__('Wheel of Fortune has been added successfully!'));
    }

    public function edit($id)
    {
        $lottery = db()->prepare("SELECT * FROM Lotteries WHERE id = ?");
        $lottery->execute(array($id));
        $lottery = $lottery->fetch();

        if (!$lottery) return view('404');

        $awards = db()->prepare("SELECT * FROM LotteryAwards WHERE lotteryID = ? AND isEnabled = ?");
        $awards->execute(array($id, 1));
        $awards = $awards->fetchAll(PDO::FETCH_ASSOC);

        $categories = db()->query("SELECT id, name, parentID FROM ProductCategories ORDER BY priority DESC");
        $categories = $categories->fetchAll(PDO::FETCH_ASSOC);

        $products = db()->query("SELECT id, name, categoryID FROM Products ORDER BY priority DESC");
		    $products = array_map(function ($product) {
			    // Exclude products that have variables
			    $variables = db()->prepare("SELECT V.id FROM ProductVariables PV INNER JOIN StoreVariables V ON PV.variableID = V.id WHERE PV.productID = ?");
			    $variables->execute(array($product["id"]));
			    if ($variables->rowCount() > 0) {
				    return null;
			    }
			    
			    return $product;
		    }, $products->fetchAll(PDO::FETCH_ASSOC));
		    $products = array_filter($products);

        $productList = ProductService::buildTree($categories, $products);

        return view('lotteries.edit', compact('lottery', 'awards', 'productList'));
    }

    public function update($id)
    {
        validate([
            'title' => 'required',
            'priceStatus' => 'required',
            'price' => 'required_if:priceStatus,1',
            'duration' => 'required_if:priceStatus,0',
            'lotteryTitle' => 'required',
            'lotteryChance' => 'required',
            'lotteryColor' => 'required',
            'lotteryAwardType' => 'required',
            'lotteryAward' => 'required',
        ]);

        if (input("priceStatus") == 0) {
          set_input('price', 0);
        } else {
          set_input('duration', 0);
        }

        $lottery = db()->prepare("SELECT * FROM Lotteries WHERE id = ?");
        $lottery->execute(array($id));
		    $lottery = $lottery->fetch();
				
				if (!$lottery) return view('404');
	    
		    if ($lottery["title"] != input("title")) {
			    $slug = SlugService::preventDuplicate(input("title"), 'Lotteries');
		    } else {
			    $slug = $lottery["slug"];
		    }

        $updateLotteries = db()->prepare("UPDATE Lotteries SET title = ?, slug = ?, price = ?, duration = ? WHERE id = ?");
        $updateLotteries->execute(array(input("title"), $slug, input("price"), input("duration"), $id));
        $disableLotteryAwards = db()->prepare("UPDATE LotteryAwards SET isEnabled = ? WHERE lotteryID = ?");
		    $disableLotteryAwards->execute(array(0, $lottery["id"]));

        foreach ($_POST["lotteryChance"] as $key => $value) {
            $_POST["lotteryTitle"][$key] = strip_tags($_POST["lotteryTitle"][$key]);
            $_POST["lotteryChance"][$key] = strip_tags(str_replace('%', '', $_POST["lotteryChance"][$key]));
            $_POST["lotteryColor"][$key] = strip_tags($_POST["lotteryColor"][$key]);
            $_POST["lotteryAwardType"][$key] = strip_tags($_POST["lotteryAwardType"][$key]);
            $_POST["lotteryAward"][$key] = ($_POST["lotteryAward"][$key] != null) ? strip_tags($_POST["lotteryAward"][$key]) : '0';
            $insertLotteryAwards = db()->prepare("INSERT INTO LotteryAwards (lotteryID, title, chance, color, awardType, award) VALUES (?, ?, ?, ?, ?, ?)");
            $insertLotteryAwards->execute(array($lottery["id"], $_POST["lotteryTitle"][$key], $_POST["lotteryChance"][$key], $_POST["lotteryColor"][$key], $_POST["lotteryAwardType"][$key], $_POST["lotteryAward"][$key]));
        }

        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $deleteLottery = db()->prepare("DELETE FROM Lotteries WHERE id = ?");
        $deleteLottery->execute(array($id));
        $deleteLotteryAwards = db()->prepare("DELETE FROM LotteryAwards WHERE lotteryID = ?");
        $deleteLotteryAwards->execute(array($id));
        return back();
    }
}