<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;
use PDO;

class LotteryLogController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_LOTTERY');
    }

    public function index()
    {
        if (isset($_GET["page"])) {
            if (!is_numeric($_GET["page"])) {
                $_GET["page"] = 1;
            }
            $page = intval(get("page"));
        } else {
            $page = 1;
        }

        $visiblePageCount = 5;
        $limit = 50;

        $lotteryLogs = db()->query("SELECT COUNT(LH.id) FROM LotteryHistory LH INNER JOIN LotteryAwards LA ON LH.lotteryAwardID = LA.id INNER JOIN Lotteries L ON LA.lotteryID = L.id INNER JOIN Accounts A ON LH.accountID = A.id");
        $itemsCount = $lotteryLogs->fetchColumn();
        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;
        $lotteryLogs = db()->query("SELECT LH.*, L.id as lotteryID, L.title as lotteryTitle, LA.title as awardTitle, LA.awardType, LA.award, A.username, A.realname FROM LotteryHistory LH INNER JOIN LotteryAwards LA ON LH.lotteryAwardID = LA.id INNER JOIN Lotteries L ON LA.lotteryID = L.id INNER JOIN Accounts A ON LH.accountID = A.id ORDER BY LH.id DESC LIMIT $visibleItemsCount, $limit");

        if (isset($_GET["search"])) {
            if (get("search") != null) {
                $lotteryLogs = db()->prepare("SELECT LH.*, L.id as lotteryID, L.title as lotteryTitle, LA.title as awardTitle, LA.awardType, LA.award, A.username, A.realname FROM LotteryHistory LH INNER JOIN LotteryAwards LA ON LH.lotteryAwardID = LA.id INNER JOIN Lotteries L ON LA.lotteryID = L.id INNER JOIN Accounts A ON LH.accountID = A.id WHERE (A.realname LIKE :search OR A.username LIKE :search) ORDER BY LH.id DESC");
                $lotteryLogs->execute(array(
                    "search" => '%' . get("search") . '%'
                ));
            }
        }

        $lotteryLogs = $lotteryLogs->fetchAll(PDO::FETCH_ASSOC);

        return view('lotteries.logs.index', compact('lotteryLogs', 'page', 'visiblePageCount', 'pageCount'));
    }

    public function show($id)
    {
      $lotteryLog = db()->prepare("SELECT LH.*, A.username, A.realname, LA.title, LA.awardType, LA.award FROM LotteryHistory LH INNER JOIN Accounts A ON LH.accountID = A.id INNER JOIN LotteryAwards LA ON LH.lotteryAwardID = LA.id WHERE LH.id = ?");
      $lotteryLog->execute(array($id));
      $lotteryLog = $lotteryLog->fetch(PDO::FETCH_ASSOC);

      if (!$lotteryLog) return view('404');

      $commandLogs = null;
      if ($lotteryLog["awardType"] == 2) {
	      $commandLogs = db()->prepare("SELECT CL.id, CL.command, S.name as serverName, P.name as productName, CL.status, CL.updatedAt FROM CommandLogs CL INNER JOIN ProductCommands PC ON PC.id = CL.commandID INNER JOIN Servers S ON S.id = PC.serverID INNER JOIN Products P ON P.id = PC.productID WHERE CL.dataType = ? AND CL.dataID = ?");
        $commandLogs->execute(array('lottery', $id));
	      $commandLogs = $commandLogs->fetchAll(PDO::FETCH_ASSOC);
      }
  
      return view('lotteries.logs.show', compact('lotteryLog', 'commandLogs'));
    }

    public function destroy($id)
    {
        $deleteLotteryHistory = db()->prepare("DELETE FROM LotteryHistory WHERE id = ?");
        $deleteLotteryHistory->execute(array($id));
        return back();
    }
}