<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;
use PDO;

class PaymentGatewayController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_PAYMENT');
    }

    public function index()
    {
        $paymentGateways = db()->query("SELECT * FROM PaymentGateways ORDER BY slug ASC");
		    $paymentGateways = $paymentGateways->fetchAll();

        return view('payment-gateways.index', compact('paymentGateways'));
    }

    public function edit($id)
    {
		    $paymentGateway = db()->prepare("SELECT * FROM PaymentGateways WHERE slug = ?");
		    $paymentGateway->execute(array($id));
		    $paymentGateway = $paymentGateway->fetch();

        if (!$paymentGateway) return view('404');
	    
		    $paymentGateway["config"] = json_decode($paymentGateway["config"], true);
				
				$currencies = db()->query("SELECT * FROM Currencies");
				$currencies = $currencies->fetchAll(PDO::FETCH_ASSOC);

        return view('payment-gateways.edit', compact('paymentGateway', 'currencies'));
    }

    public function update($id)
    {
        validate([
          'title' => 'required',
					'order' => 'required|numeric',
          'status' => 'required',
	        'feeStatus' => 'required|in:0,1',
					'transactionFee' => 'required_if:feeStatus,1|numeric',
	        'fixedFee' => 'required_if:feeStatus,1|numeric',
        ]);

        $paymentGateways = db()->prepare("SELECT * FROM PaymentGateways WHERE slug = ?");
		    $paymentGateways->execute(array($id));
        $paymentGateways = $paymentGateways->fetch();

        if (!$paymentGateways) return view('404');
				
				// Find post values starts with config__
        $configArray = [];
				foreach ($_POST as $key => $value) {
						if (strpos($key, "config__") !== false) {
								$configKey = str_replace("config__", "", $key);
								$configArray[$configKey] = $value;
						}
				}
	   
				// Update config values
				$config = json_decode($paymentGateways["config"], true);
		    foreach ($config as &$configItem) {
			    $key = $configItem['key'];
			    if (isset($configArray[$key])) {
				    $configItem['value'] = $configArray[$key];
			    }
		    }

        $configJSON = json_encode($config);
        $updatePaymentGateways = db()->prepare("UPDATE PaymentGateways SET title = ?, `order` = ?, status = ?, currency = ?, feeStatus = ?, transactionFee = ?, fixedFee = ?, config = ? WHERE slug = ?");
		    $updatePaymentGateways->execute(array(input("title"), input("order"), input("status"), input("currency"), input("feeStatus"), input("transactionFee"), input("fixedFee"), $configJSON, $id));

        return back()->flash("success", t__('Changes has been saved successfully!'));
    }
}