<?php
	
	namespace Dashboard\Controllers;
	
	use Dashboard\Core\Controller;
	use Verot\Upload\Upload;
	
	class PopupController extends Controller
	{
		public function __construct()
		{
			abort_perm('MANAGE_SETTINGS');
		}
		
		public function edit()
		{
			return view('popup.edit');
		}
		
		public function update()
		{
			validate([
				'image' => 'required|uploaded_file',
				'link' => 'required',
			]);
			
			$upload = new Upload($_FILES["image"]);
			$imageID = md5(uniqid(rand(0, 9999)));
			if ($upload->uploaded) {
				$upload->allowed = array("image/*");
				$upload->file_overwrite = true;
				$upload->file_new_name_body = $imageID;
				$upload->process(__ROOT__ . "/apps/main/public/images/uploads/");
				if ($upload->processed) {
          updateModuleSettings('popup', [
						'image' => $imageID . '.' . $upload->file_src_name_ext,
						'link' => input('link')
					]);
				}
				else {
					return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
				}
			}
			
			return back()->flash("success", t__('Changes has been saved successfully!'));
		}
	}