<?php

namespace Dashboard\Controllers;

use Curl\Curl;
use Dashboard\Core\Controller;
use Verot\Upload\Upload;

class ServerController extends Controller
{
	
	private $leaderosConnectSupportedGames;
	
  public function __construct()
  {
    abort_perm('MANAGE_SERVERS');
		
		$this->leaderosConnectSupportedGames = [
			"minecraft",
			"fivem",
			"rust"
		];
  }

  public function index(): string
  {
    $servers = db()->query("SELECT * FROM Servers ORDER BY id DESC");
    $servers = $servers->fetchAll();

    return view('servers.index', compact('servers'));
  }

  public function create(): string
  {
    return view('servers.create', [
			'leaderosConnectSupportedGames' => $this->leaderosConnectSupportedGames
    ]);
  }

  public function edit($id): string
  {
    $server = db()->prepare("SELECT * FROM Servers WHERE id = ?");
    $server->execute(array($id));
    $server = $server->fetch();

    if (!$server) return view('404');

    return view('servers.edit', [
			'server' => $server,
	    'leaderosConnectSupportedGames' => $this->leaderosConnectSupportedGames
    ]);
  }

  public function store()
  {
    validate([
      'name' => 'required',
      'ip' => 'required',
      'port' => 'required',
      'consoleID' => 'required',
      'consolePort' => 'required_if:consoleID,1,2,3',
      'consolePassword' => 'required_if:consoleID,1,2,3',
    ]);

    if (input('consoleID') == 4) {
      if (settings('apiStatus') != 1 || settings('apiKey') == "")
        return back()->flash("error", t__('API is not ready to use! Please set up API from Settings > API'));

			$apiKey = settings('apiKey');
      $token = md5(uniqid(rand(0, 99999)));

      $curl = new Curl();
      $curl->setHeader('Content-Type', 'application/json');
	    $curl->setHeader('Accept', 'application/json');
      $curl->post("https://connect-api.leaderos.net/api/api-keys/$apiKey/tokens", [
        "token"    => $token,
      ]);

      if (!isset($curl->response->status) || !$curl->response->status) {
        $token = null;
      }
    } else {
      $token = null;
    }

    $insertServers = db()->prepare("INSERT INTO Servers (name, ip, port, consoleID, consolePort, consolePassword, consoleToken) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $insertServers->execute(array(input("name"), input("ip"), input("port"), input("consoleID"), input("consolePort"), input("consolePassword"), $token));
    $id = db()->lastInsertId();

    if (input('consoleID') == '4') {
      redirect(url('dashboard.servers.plugin', [
        'id' => $id
      ]));
    }

    return back()->flash("success", t__('Server has been added successfully!'));
  }

  public function update($id)
  {
    validate([
      'name' => 'required',
      'ip' => 'required',
      'port' => 'required',
      'consoleID' => 'required',
      'consolePort' => 'required_if:consoleID,1,2,3',
      'consolePassword' => 'required_if:consoleID,1,2,3',
    ]);

    $server = db()->prepare("SELECT * FROM Servers WHERE id = ?");
    $server->execute(array($id));
    $server = $server->fetch();

    if (!$server) return view('404');

    $token = $server["consoleToken"];
    if ($server["consoleID"] != 4 && input('consoleID') == 4) {
      if (settings('apiStatus') != 1 || settings('apiKey') == "")
        return back()->flash("error", t__('API is not ready to use! Please set up API from Settings > API'));

			$apiKey = settings('apiKey');
      $token = md5(uniqid(rand(0, 99999)));

      $curl = new Curl();
      $curl->setHeader('Content-Type', 'application/json');
	    $curl->setHeader('Accept', 'application/json');
      $curl->post("https://connect-api.leaderos.net/api/api-keys/$apiKey/tokens", [
        "token"    => $token,
      ]);

      if (!isset($curl->response->status) || !$curl->response->status) {
        $token = null;
      }
    }

    if ($server["consoleID"] == 4 && input('consoleID') != 4 && settings('apiStatus') == 1 && settings('apiKey') != "") {
			$apiKey = settings('apiKey');
			$token = $server["consoleToken"];
			
      if ($token != null && $token != "") {
	      $curl = new Curl();
	      $curl->setHeader('Content-Type', 'application/json');
	      $curl->setHeader('Accept', 'application/json');
	      $curl->delete("https://connect-api.leaderos.net/api/api-keys/$apiKey/tokens/$token");
			}
      $token = null;
    }

    $updateServers = db()->prepare("UPDATE Servers SET name = ?, ip = ?, port = ?, consoleID = ?, consolePort = ?, consolePassword = ?, consoleToken = ? WHERE id = ?");
    $updateServers->execute(array(input("name"), input("ip"), input("port"), input("consoleID"), input("consolePort"), input("consolePassword"), $token, $id));

    if ($server["consoleID"] != 4 && input('consoleID') == '4') {
      redirect(url('dashboard.servers.plugin', [
        'id' => $id
      ]));
    }

    return back()->flash("success", t__('Changes has been saved successfully!'));
  }

  public function destroy($id)
  {
		$server = db()->prepare("SELECT * FROM Servers WHERE id = ?");
		$server->execute([$id]);
		$server = $server->fetch();
		
		if (!$server) return back();
		
    $deleteServer = db()->prepare("DELETE FROM Servers WHERE id = ?");
    $deleteServer->execute(array($server["id"]));
	  
	  if ($server["consoleID"] == 4 && settings('apiStatus') == 1 && settings('apiKey') != "") {
		  $apiKey = settings('apiKey');
		  $token = $server["consoleToken"];
		  
		  if ($token != null && $token != "") {
			  $curl = new Curl();
			  $curl->setHeader('Content-Type', 'application/json');
			  $curl->setHeader('Accept', 'application/json');
			  $curl->delete("https://connect-api.leaderos.net/api/api-keys/$apiKey/tokens/$token");
		  }
		  $token = null;
	  }

    return back();
  }

  public function resetConsoleToken($id)
  {
    $server = db()->prepare("SELECT * FROM Servers WHERE id = ?");
    $server->execute(array($id));

    if ($server->rowCount() == 0)
      response()->json([
        'status' => false,
        'message' => t__('Server not found!')
      ]);

    $server = $server->fetch();

    if ($server["consoleID"] != 4)
      response()->json([
        'status' => false,
        'message' => t__('This server is not using LeaderOS Connect!')
      ]);

    if (settings('apiStatus') != 1 || settings('apiKey') == "")
      response()->json([
        'status' => false,
        'message' => t__('API is not ready to use! Please set up API from Settings > API')
      ]);

		$apiKey = settings('apiKey');
    $currentToken = $server["consoleToken"];
    $token = md5(uniqid(rand(0, 99999)));

    $curl = new Curl();
    $curl->setHeader('Content-Type', 'application/json');
	  $curl->setHeader('Accept', 'application/json');
    if ($currentToken == null) {
      $curl->post("https://connect-api.leaderos.net/api/api-keys/$apiKey/tokens", [
        "token"    => $token,
      ]);
    } else {
      $curl->patch("https://connect-api.leaderos.net/api/api-keys/$apiKey/tokens/$currentToken", [
        "token"    => $token,
      ]);
    }

    if (isset($curl->response->status) && $curl->response->status) {
      $updateServers = db()->prepare("UPDATE Servers SET consoleToken = ? WHERE id = ?");
      $updateServers->execute(array($token, $id));

      response()->json([
        'status' => true,
        'token' => $token,
        'message' => t__('Changes has been saved successfully!')
      ]);
    }

    response()->json([
      'status' => false,
      'message' => (isset($curl->response->error)) ? $curl->response->error : t__('Error!')
    ]);
  }

  public function plugin($id): string
  {
    $server = db()->prepare("SELECT * FROM Servers WHERE id = ?");
    $server->execute(array($id));
    $server = $server->fetch();

    if (!$server) return view('404');
		
		$game = settings('gameType');
    return view("servers.plugins.$game", compact('server'));
  }
}