<?php
	
	namespace Dashboard\Controllers\Settings;
	
	use Dashboard\Core\Controller;
	use PDO;
	
	class AccountLinkingController extends Controller
	{
		public function __construct()
		{
			abort_perm('MANAGE_SETTINGS');
		}
		
		public function index()
		{
			$providers = db()->prepare("SELECT * FROM AccountLinkingProviders WHERE slug != ?");
			$providers->execute([settings('loginProvider')]);
			$providers = $providers->fetchAll(PDO::FETCH_ASSOC);
			
			return view('settings.account-linking.index', compact('providers'));
		}
		
		public function toggleProvider($id)
		{
			$provider = db()->prepare("SELECT * FROM AccountLinkingProviders WHERE id = ?");
			$provider->execute([$id]);
			$provider = $provider->fetch(PDO::FETCH_ASSOC);
			
			$status = $provider['isEnabled'] == '0' ? '1' : '0';
			
			// Disable the current login provider
			if ($provider['slug'] == settings('loginProvider')) {
				$status = '0';
			}
			
			$updateProvider = db()->prepare("UPDATE AccountLinkingProviders SET isEnabled = ? WHERE id = ?");
			$updateProvider->execute([$status, $id]);
			
			createLog("account_linking_PROVIDER_TOGGLED");
			
			response()->json([
				'status' => 'success',
				'message' => $status == '1' ? t__('Provider enabled successfully!') : t__('Provider disabled successfully!')
			]);
		}
	}