<?php

namespace Dashboard\Controllers\Settings;

use Dashboard\Core\Controller;

class ChestController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_SETTINGS');
    }

    public function index()
    {
        return view('settings.chest.index');
    }

    public function update()
    {
        $module = db()->prepare("SELECT * FROM Modules WHERE slug = ?");
        $module->execute(['chest']);
        $module = $module->fetch();
        if (!$module) {
            abort_404();
        }

        foreach ($_POST as $key => $value) {
            $updateSettings = db()->prepare("UPDATE ModuleSettings SET value = ? WHERE name = ? AND moduleID = ?");
            $updateSettings->execute([input($key), $key, $module['id']]);
        }
        createLog("CHEST_SETTINGS_UPDATED");

        return back()->flash("success", t__('Changes has been saved successfully!'));
    }
}