<?php

namespace Dashboard\Controllers\Settings;

use Dashboard\Core\Controller;

class CreditController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_SETTINGS');
    }

    public function index()
    {
        return view('settings.credit.index');
    }

    public function update()
    {
        $module = db()->prepare("SELECT * FROM Modules WHERE slug = ?");
        $module->execute(['credit']);
        $module = $module->fetch();
        if (!$module) {
            abort_404();
        }
	    
	    if (input("bonusCreditStatus") == 0) {
		    set_input("bonusCredit", '0');
		    set_input("bonusCreditMinAmount", '0');
	    }
	    if (input("bonusCreditStatus") == 0 || input("bonusCreditExpiryStatus") == 0) {
		    set_input("bonusCreditExpiryDate", '1000-01-01 00:00:00');
	    }

        foreach ($_POST as $key => $value) {
            $updateSettings = db()->prepare("UPDATE ModuleSettings SET value = ? WHERE name = ? AND moduleID = ?");
            $updateSettings->execute([input($key), $key, $module['id']]);
        }
        createLog("CREDIT_SETTINGS_UPDATED");

        return back()->flash("success", t__('Changes has been saved successfully!'));

    }
}