<?php

namespace Dashboard\Controllers\Settings;

use Dashboard\Core\Controller;
use PDO;

class CurrencyController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_SETTINGS');
    }

    public function index()
    {
        $currencies = db()->query("SELECT * FROM Currencies");
        $currencies = $currencies->fetchAll(PDO::FETCH_ASSOC);

        return view('settings.currencies.index', compact('currencies'));
    }

    public function edit($id)
    {
      $currency = db()->prepare("SELECT * FROM Currencies WHERE code = ?");
      $currency->execute(array($id));
      $currency = $currency->fetch();

      if (!$currency) return view('404');

      return view('settings.currencies.edit', compact('currency'));
    }

    public function update($id)
    {
      validate([
        'label' => 'required',
        'prefix' => 'nullable',
        'suffix' => 'nullable',
        'rate' => 'required',
        'autoUpdate' => 'required',
      ]);

      $updateCurrency = db()->prepare("UPDATE Currencies SET label = ?, prefix = ?, suffix = ?, rate = ?, autoUpdate = ? WHERE code = ?");
      $updateCurrency->execute(array(input("label"), input("prefix"), input("suffix"), input("rate"), input("autoUpdate"), $id));

      return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        if (settings("currency") != $id) {
            $deleteCurrency = db()->prepare("DELETE FROM Currencies WHERE code = ?");
            $deleteCurrency->execute(array($id));
        }
        return back();
    }

    public function set($id)
    {
        $data = checkCurrency($id);
        if (empty($data["rates"])) {
          back()->flash("error", t__("Something went wrong, please try again later!"));
        }
	    
		    $currency = db()->prepare("SELECT * FROM Currencies WHERE code = ?");
		    $currency->execute(array($id));
		    $currency = $currency->fetch();
		    
		    if (!$currency) return view('404');
				
				// Prevent setting the disabled currency as default
	      if ($currency['isActive'] == 0) return back();

        $currencies = db()->query("SELECT * FROM Currencies");
        $currencies = $currencies->fetchAll(PDO::FETCH_ASSOC);
        foreach ($currencies as $currency) {
          if (!isset($data["rates"][$currency["code"]]) || $data["rates"][$currency["code"]] == 0)
            continue;

          $updateCurrency = db()->prepare("UPDATE Currencies SET rate = ? WHERE code = ?");
          $updateCurrency->execute(array($data["rates"][$currency["code"]], $currency["code"]));
        }

        updateSetting("currency", $id);
        updateSetting("lastCheckCurrencies", datetime());

        return back();
    }

  public function toggle($id)
  {
    $currency = db()->prepare("SELECT * FROM Currencies WHERE code = ?");
    $currency->execute(array($id));
    $currency = $currency->fetch();
	  
	  if (!$currency) return view('404');
		
		// Prevent disabling the default currency
		if (settings('currency') == $currency["code"] && $currency['isActive'] == '1') return back();

    $updateCurrency = db()->prepare("UPDATE Currencies SET isActive = ? WHERE code = ?");
    $updateCurrency->execute(array($currency['isActive'] == '0' ? '1' : '0', $id));

    return back();
  }
}