<?php

namespace Dashboard\Controllers\Settings;

use Dashboard\Core\Controller;
use PDO;

class DiscordWebhookController extends Controller
{
	
		private $events;
		
    public function __construct()
    {
        abort_perm('MANAGE_SETTINGS');
				
				$this->events = [
					[
						'value' => 'forum.thread.posted',
						'name' => t__('Forum Thread Posted'),
						'description' => t__('When a user posts a new thread in the forum'),
						'variables' => [
							'{username}' => t__('Username'),
							'{title}' => t__('Title'),
							'{url}' => t__('URL')
						]
					],
					[
						'value' => 'store.purchase.credit',
						'name' => t__('Credits Purchased'),
						'description' => t__('When a user purchases credits'),
						'variables' => [
							'{username}' => t__('Username'),
							'{credit}' => t__('Amount'),
							'{currency}' => t__('Currency'),
						]
					],
					[
						'value' => 'store.purchase.product',
						'name' => t__('Product Purchased'),
						'description' => t__('When a user purchases a product from the store'),
						'variables' => [
							'{username}' => t__('Username'),
							'{category}' => t__('Category'),
							'{product}' => t__('Product'),
							'{quantity}' => t__('Quantity'),
							'{price}' => t__('Price'),
							'{currency}' => t__('Currency')
						]
					],
					[
						'value' => 'support.ticket.opened',
						'name' => t__('Support Ticket Opened'),
						'description' => t__('When a user opens a new ticket'),
						'variables' => [
							'{username}' => t__('Username'),
							'{category}' => t__('Category'),
							'{title}' => t__('Title'),
							'{message}' => t__('Message'),
							'{dashboard_url}' => t__('Dashboard URL')
						]
					],
					[
						'value' => 'support.ticket.answered',
						'name' => t__('Support Ticket Answered'),
						'description' => t__('When a staff answers a ticket'),
						'variables' => [
							'{username}' => t__('Username'),
							'{category}' => t__('Category'),
							'{title}' => t__('Title'),
							'{message}' => t__('Message'),
							'{dashboard_url}' => t__('Dashboard URL')
						]
					],
					[
						'value' => 'support.ticket.replied',
						'name' => t__('Support Ticket Replied'),
						'description' => t__('When a user replies to a ticket'),
						'variables' => [
							'{username}' => t__('Username'),
							'{category}' => t__('Category'),
							'{title}' => t__('Title'),
							'{message}' => t__('Message'),
							'{dashboard_url}' => t__('Dashboard URL')
						]
					],
					[
						'value' => 'support.ticket.closed',
						'name' => t__('Support Ticket Closed'),
						'description' => t__('When a staff closes a ticket'),
						'variables' => [
							'{username}' => t__('Username'),
							'{category}' => t__('Category'),
							'{title}' => t__('Title'),
							'{dashboard_url}' => t__('Dashboard URL')
						]
					],
					[
						'value' => 'blog.post.published',
						'name' => t__('Blog Post Published'),
						'description' => t__('When a staff publishes a new blog post'),
						'variables' => [
							'{username}' => t__('Username'),
							'{title}' => t__('Title'),
							'{content}' => t__('Content'),
							'{category}' => t__('Category'),
							'{thumbnail}' => t__('Thumbnail'),
							'{url}' => t__('URL')
						]
					],
					[
						'value' => 'blog.post.commented',
						'name' => t__('Blog Post Commented'),
						'description' => t__('When a user comments on a blog post'),
						'variables' => [
							'{username}' => t__('Username'),
							'{comment}' => t__('Comment'),
							'{title}' => t__('Title'),
							'{url}' => t__('URL'),
							'{dashboard_url}' => t__('Dashboard URL')
						]
					],
					[
						'value' => 'wheel.won',
						'name' => t__('Wheel of Fortune Won'),
						'description' => t__('When a user wins a prize from the wheel of fortune'),
						'variables' => [
							'{username}' => t__('Username'),
							'{name}' => t__('Name'),
							'{award}' => t__('Award')
						]
					],
					[
						'value' => 'application.submitted',
						'name' => t__('Application Submitted'),
						'description' => t__('When a user submits an application'),
						'variables' => [
							'{username}' => t__('Username'),
							'{form_title}' => t__('Form Title'),
							'{dashboard_url}' => t__('Dashboard URL')
						]
					],
					[
						'value' => 'changelog.published',
						'name' => t__('Changelog Published'),
						'description' => t__('When a staff publishes a new changelog'),
						'variables' => [
							'{username}' => t__('Username'),
							'{title}' => t__('Title'),
							'{url}' => t__('URL'),
						]
					]
				];
    }

    public function index()
    {
			$discordWebhooks = db()->query("SELECT * FROM DiscordWebhooks ORDER BY id DESC");
			$discordWebhooks = $discordWebhooks->fetchAll(PDO::FETCH_ASSOC);
			
			$discordWebhooks = array_map(function($webhook) {
				$webhook['eventName'] = $this->events[array_search($webhook['event'], array_column($this->events, 'value'))]['name'];
				
				return $webhook;
			}, $discordWebhooks);
			
      return view('discord-webhooks.index', compact('discordWebhooks'));
    }
		
		public function create()
		{
			return view('discord-webhooks.create', [
				'events' => $this->events
			]);
		}
		
		public function store()
		{
			validate([
				'name' => 'required',
				'url' => 'required|url:https',
				'event' => 'required',
				'botName' => 'required',
				'botAvatar' => 'required|url:https',
				'data' => 'required|json'
			]);
			
			$insertDiscordWebhook = db()->prepare("INSERT INTO DiscordWebhooks (name, url, event, botName, botAvatar, data) VALUES (?, ?, ?, ?, ?, ?)");
			$insertDiscordWebhook->execute([input('name'), input('url'), input('event'), input('botName'), input('botAvatar'), input('data')]);

			createLog("WEBHOOK_SETTINGS_CREATED");

			return back()->flash("success", t__('Discord Webhook has been created successfully!'));
		}

		public function edit($id)
		{
			$discordWebhook = db()->prepare("SELECT * FROM DiscordWebhooks WHERE id = ?");
			$discordWebhook->execute([$id]);
			$discordWebhook = $discordWebhook->fetch(PDO::FETCH_ASSOC);
			
			if (!$discordWebhook) return view('404');
			
			return view('discord-webhooks.edit', [
				'discordWebhook' => $discordWebhook,
				'events' => $this->events
			]);
		}

    public function update($id)
    {
      validate([
				'name' => 'required',
				'url' => 'required|url:https',
        'event' => 'required',
	      'botName' => 'required',
	      'botAvatar' => 'required|url:https',
        'data' => 'required|json',
	      'isActive' => 'required'
      ]);
			
			$updateDiscordWebhook = db()->prepare("UPDATE DiscordWebhooks SET name = ?, url = ?, event = ?, botName = ?, botAvatar = ?, data = ?, isActive = ? WHERE id = ?");
			$updateDiscordWebhook->execute([input('name'), input('url'), input('event'), input('botName'), input('botAvatar'), input('data'), input('isActive'), $id]);

      createLog("WEBHOOK_SETTINGS_UPDATED");

      return back()->flash("success", t__('Changes has been saved successfully!'));
    }
		
		public function destroy($id)
		{
			$deleteDiscordWebhook = db()->prepare("DELETE FROM DiscordWebhooks WHERE id = ?");
			$deleteDiscordWebhook->execute([$id]);
			
			createLog("WEBHOOK_SETTINGS_DELETED");
	
			return back();
		}
}