<?php
	
	namespace Dashboard\Controllers\Settings;
	
	use Dashboard\Core\Controller;
	
	class EmailTemplateController extends Controller
	{
		protected array $templates = [];
		
		public function __construct()
		{
			abort_perm('MANAGE_SETTINGS');
			
			$this->templates = [
				[
					'label' => t__('Recover Password Template'),
					'module' => 'core',
					'name' => 'reset_password',
					'title' => [
						'name' => 'smtpPasswordTitle',
						'value' => settings('smtpPasswordTitle'),
					],
					'content' => [
						'name' => 'smtpPasswordTemplate',
						'value' => settings('smtpPasswordTemplate'),
					],
					'variables' => [
						[
							'name' => t__('Username'),
							'value' => '%username%',
						],
						[
							'name' => t__('Recover Password URL'),
							'value' => '%url%',
						]
					]
				]
			];
			
			// Add more templates as needed
			if (settings('emailChangeVerification') == '1') {
				$this->templates[] = [
					'label' => t__('Email Change Verification Template'),
					'module' => 'core',
					'name' => 'change_email_verification',
					'title' => [
						'name' => 'smtpVerifyEmailChangeTitle',
						'value' => settings('smtpVerifyEmailChangeTitle'),
					],
					'content' => [
						'name' => 'smtpVerifyEmailChangeTemplate',
						'value' => settings('smtpVerifyEmailChangeTemplate'),
					],
					'variables' => [
						[
							'name' => t__('Username'),
							'value' => '%username%',
						],
						[
							'name' => t__('Email'),
							'value' => '%email%',
						],
						[
							'name' => t__('Verification URL'),
							'value' => '%url%',
						]
					]
				];
			}
			if (!moduleIsDisabled('tfa')) {
				$this->templates[] = [
					'label' => t__('TFA Recover Template'),
					'module' => 'tfa',
					'name' => 'reset_tfa',
					'title' => [
						'name' => 'tfaEmailTitle',
						'value' => moduleSettings('tfa', 'tfaEmailTitle'),
					],
					'content' => [
						'name' => 'tfaEmailTemplate',
						'value' => moduleSettings('tfa', 'tfaEmailTemplate'),
					],
					'variables' => [
						[
							'name' => t__('Username'),
							'value' => '%username%',
						],
						[
							'name' => t__('TFA Recover URL'),
							'value' => '%url%',
						]
					]
				];
			}
			if (!moduleIsDisabled('email_verification')) {
				$this->templates[] = [
					'label' => t__('Email Verification Template'),
					'module' => 'email_verification',
					'name' => 'verify_email',
					'title' => [
						'name' => 'verifyEmailTitle',
						'value' => moduleSettings('email_verification', 'verifyEmailTitle'),
					],
					'content' => [
						'name' => 'verifyEmailTemplate',
						'value' => moduleSettings('email_verification', 'verifyEmailTemplate'),
					],
					'variables' => [
						[
							'name' => t__('Username'),
							'value' => '%username%',
						],
						[
							'name' => t__('Verification URL'),
							'value' => '%url%',
						]
					]
				];
			}
			if (!moduleIsDisabled('store') && moduleSettings('store', 'sendEmailOnPurchase') == '1') {
				$this->templates[] = [
					'label' => t__('Purchase Template'),
					'module' => 'store',
					'name' => 'purchase',
					'title' => [
						'name' => 'purchaseEmailTitle',
						'value' => moduleSettings('store', 'purchaseEmailTitle'),
					],
					'content' => [
						'name' => 'purchaseEmailTemplate',
						'value' => moduleSettings('store', 'purchaseEmailTemplate'),
					],
					'variables' => [
						[
							'name' => t__('Username'),
							'value' => '%username%',
						],
						[
							'name' => t__('Order URL'),
							'value' => '%url%',
						],
						[
							'name' => t__('Products'),
							'value' => '%items%',
						],
						[
							'name' => t__('Total'),
							'value' => '%total%',
						],
						[
							'name' => t__('Discount'),
							'value' => '%discount%',
						]
					]
				];
			}
			if (!moduleIsDisabled('support') && moduleSettings('support', 'sendEmailOnAnswered') == '1') {
				$this->templates[] = [
					'label' => t__('Ticket Answered Template'),
					'module' => 'support',
					'name' => 'ticket_answered',
					'title' => [
						'name' => 'answeredEmailTitle',
						'value' => moduleSettings('support', 'answeredEmailTitle'),
					],
					'content' => [
						'name' => 'answeredEmailTemplate',
						'value' => moduleSettings('support', 'answeredEmailTemplate'),
					],
					'variables' => [
						[
							'name' => t__('Username'),
							'value' => '%username%',
						],
						[
							'name' => t__('Ticket URL'),
							'value' => '%url%',
						],
						[
							'name' => t__('Subject'),
							'value' => '%subject%',
						],
						[
							'name' => t__('Category'),
							'value' => '%category%',
						]
					]
				];
			}
			
			$this->templates = array_map(function ($template) {
				$template["id"] = $template["module"] . '_' . $template["name"];
				
				return $template;
			}, $this->templates);
		}
		
		public function index()
		{
			if (get('tab') == null) {
				// Redirect to the first template
				$template = array_shift($this->templates);
				redirect('?tab=' . $template['id']);
			}
			
			// Find template
			$template = array_filter($this->templates, function ($template) {
				return $template['id'] == get('tab');
			});
			
			if (empty($template)) {
				abort(404);
			}
			
			return view('settings.email-templates.index', [
				'templates' => $this->templates,
				'template' => array_shift($template),
			]);
		}
		
		public function update($id)
		{
			$template = array_filter($this->templates, function ($template) use ($id) {
				return $template['id'] == $id;
			});
			if (empty($template)) {
				abort(404);
			}
			$template = array_shift($template);
			
			if ($template['module'] == 'core') {
				$updateSettings = db()->prepare("UPDATE Settings SET value = ? WHERE name = ?");
				$updateSettings->execute([input($template['title']['name']), $template['title']['name']]);
				$updateSettings->execute([input($template['content']['name']), $template['content']['name']]);
			} else {
				$module = db()->prepare("SELECT id FROM Modules WHERE slug = ?");
				$module->execute([$template['module']]);
				$module = $module->fetch();
				if (!$module) {
					abort(404);
				}
				$updateSettings = db()->prepare("UPDATE ModuleSettings SET value = ? WHERE name = ? AND moduleID = ?");
				$updateSettings->execute([input($template['title']['name']), $template['title']['name'], $module['id']]);
				$updateSettings->execute([input($template['content']['name']), $template['content']['name'], $module['id']]);
			}
			createLog("EMAIL_TEMPLATES_UPDATED");
			
			return back()->flash("success", t__('Changes has been saved successfully!'));
		}
	}