<?php

namespace Dashboard\Controllers\Settings;

use Dashboard\Core\Controller;
use Dashboard\Core\Redirect;
use Dashboard\Libs\Parasut;

class ParasutController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_SETTINGS');
    }

    public function index()
    {
        return view('settings.parasut.index');
    }

    public function update()
    {
        $module = db()->prepare("SELECT * FROM Modules WHERE slug = ?");
        $module->execute(['parasut']);
        $module = $module->fetch();
        if (!$module) {
            abort_404();
        }

        foreach ($_POST as $key => $value) {
            $updateSettings = db()->prepare("UPDATE ModuleSettings SET value = ? WHERE name = ? AND moduleID = ?");
            $updateSettings->execute([$value, $key, $module['id']]);
        }
        createLog("PARASUT_SETTINGS_UPDATED");

        redirect(url('dashboard.settings.parasut.oauth'));
    }

    public function oauth()
    {
      if (moduleSettings('parasut', 'authType') == 1) {
        $parasut = new Parasut(moduleSettings('parasut', 'clientID'), moduleSettings('parasut', 'clientSecret'), moduleSettings('parasut', 'companyID'));

        $accessTokenResponse = $parasut->getAccessTokenWithPassword(moduleSettings('parasut', 'username'), moduleSettings('parasut', 'password'));
        $accessToken = $accessTokenResponse->access_token;
        $refreshToken = $accessTokenResponse->refresh_token;
        $expiresIn = $accessTokenResponse->expires_in;

        //$createProduct = $parasut->createProduct($accessToken, "Dijital Ürün");
        //$productID = $createProduct->data->id;

        updateModuleSettings('parasut', [
          "accessToken" => $accessToken,
          "refreshToken" => $refreshToken,
          "tokenExpiryDate" => date('Y-m-d H:i:s', time() + $expiresIn),
	        //'productID' => $productID,
        ]);

        $redirect = new Redirect(url('dashboard.settings.parasut.index'));
        return $redirect->flash("success", t__('Changes has been saved successfully!'));
      } else {
        $redirectUrl = settings('websiteURL').url('settings.parasut.oauth');
        if (get('code')) {
          $parasut = new Parasut(moduleSettings('parasut', 'clientID'), moduleSettings('parasut', 'clientSecret'), moduleSettings('parasut', 'companyID'));

          $accessTokenResponse = $parasut->getAccessToken(get('code'), $redirectUrl);
          $accessToken = $accessTokenResponse->access_token;
          $refreshToken = $accessTokenResponse->refresh_token;
          $expiresIn = $accessTokenResponse->expires_in;
	        
	        //$createProduct = $parasut->createProduct($accessToken, "Dijital Ürün");
	        //$productID = $createProduct->data->id;

          updateModuleSettings('parasut', [
            "accessToken" => $accessToken,
            "refreshToken" => $refreshToken,
            "tokenExpiryDate" => date('Y-m-d H:i:s', time() + $expiresIn),
              //'productID' => $productID,
          ]);

          $redirect = new Redirect(url('dashboard.settings.parasut.index'));
          return $redirect->flash("success", t__('Changes has been saved successfully!'));
        } else {
          redirect('https://api.parasut.com/oauth/authorize?client_id='.moduleSettings('parasut', 'clientID').'&redirect_uri='.$redirectUrl.'&response_type=code');
        }
      }
    }
}