<?php

namespace Dashboard\Controllers\Settings;

use Dashboard\Core\Controller;

class PunishmentController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_SETTINGS');
    }

    public function index()
    {
        return view('settings.punishments.index');
    }

    public function update()
    {
        $module = db()->prepare("SELECT * FROM Modules WHERE slug = ?");
        $module->execute(['punishments']);
        $module = $module->fetch();
        if (!$module) {
            abort_404();
        }

        if (input("mysqlServerStatus") == 0) {
          set_input("mysqlHost", "");
          set_input("mysqlPort", "3306");
          set_input("mysqlUsername", "");
          set_input("mysqlPassword", "");
          set_input("mysqlDatabase", "");
        }

        foreach ($_POST as $key => $value) {
            $updateSettings = db()->prepare("UPDATE ModuleSettings SET value = ? WHERE name = ? AND moduleID = ?");
            $updateSettings->execute([input($key), $key, $module['id']]);
        }
        createLog("PUNISHMENT_SETTINGS_UPDATED");

        return back()->flash("success", t__('Changes has been saved successfully!'));

    }
}