<?php

namespace Dashboard\Controllers\Settings;

use Dashboard\Core\Controller;

class RecaptchaController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_SETTINGS');
    }

    public function index()
    {
	    $recaptchaPagesStatusJSON = moduleSettings('recaptcha', 'pagesStatus');
	    $recaptchaPagesStatus = json_decode($recaptchaPagesStatusJSON, true);
			
        return view('settings.recaptcha.index', compact('recaptchaPagesStatus'));
    }

    public function update()
    {
        $module = db()->prepare("SELECT * FROM Modules WHERE slug = ?");
        $module->execute(['recaptcha']);
        $module = $module->fetch();
        if (!$module) {
            abort_404();
        }
	    
	    $recaptchaPagesStatusJSON = moduleSettings('recaptcha', 'pagesStatus');
	    $recaptchaPagesStatus = json_decode($recaptchaPagesStatusJSON, true);
	    
	    $recaptchaPagesStatusArray = $recaptchaPagesStatus;
	    if (input("publicKey") == "" || input("privateKey") == "") {
		    $recaptchaPagesStatusArray["login"] = 0;
		    $recaptchaPagesStatusArray["register"] = 0;
		    $recaptchaPagesStatusArray["forgot_password"] = 0;
		    $recaptchaPagesStatusArray["reply_blog_post"] = 0;
		    $recaptchaPagesStatusArray["open_ticket"] = 0;
		    $recaptchaPagesStatusArray["reply_ticket"] = 0;
		    $recaptchaPagesStatusArray["tfa"] = 0;
		    $recaptchaPagesStatusArray["post_thread"] = 0;
		    $recaptchaPagesStatusArray["reply_thread"] = 0;
		    $recaptchaPagesStatusArray["post_suggestion"] = 0;
		    $recaptchaPagesStatusArray["reply_suggestion"] = 0;
	    } else {
		    $recaptchaPagesStatusArray["login"] = $_POST["pagesStatus"][0];
		    $recaptchaPagesStatusArray["register"] = $_POST["pagesStatus"][1];
		    $recaptchaPagesStatusArray["forgot_password"] = $_POST["pagesStatus"][2];
		    $recaptchaPagesStatusArray["reply_blog_post"] = $_POST["pagesStatus"][3];
		    $recaptchaPagesStatusArray["open_ticket"] = $_POST["pagesStatus"][4];
		    $recaptchaPagesStatusArray["reply_ticket"] = $_POST["pagesStatus"][5];
		    $recaptchaPagesStatusArray["tfa"] = $_POST["pagesStatus"][6];
		    $recaptchaPagesStatusArray["post_thread"] = $_POST["pagesStatus"][7];
		    $recaptchaPagesStatusArray["reply_thread"] = $_POST["pagesStatus"][8];
		    $recaptchaPagesStatusArray["post_suggestion"] = $_POST["pagesStatus"][9];
		    $recaptchaPagesStatusArray["reply_suggestion"] = $_POST["pagesStatus"][10];
	    }
	    $recaptchaPagesStatusJSON = json_encode($recaptchaPagesStatusArray);

        foreach ($_POST as $key => $value) {
	        if ($key == "pagesStatus") {
		        $value = $recaptchaPagesStatusJSON;
	        } else {
		        $value = input($key);
	        }
					
            $updateSettings = db()->prepare("UPDATE ModuleSettings SET value = ? WHERE name = ? AND moduleID = ?");
            $updateSettings->execute([$value, $key, $module['id']]);
        }
        createLog("RECAPTCHA_SETTINGS_UPDATED");

        return back()->flash("success", t__('Changes has been saved successfully!'));

    }
}