<?php

namespace Dashboard\Controllers\Settings;

use Dashboard\Core\Controller;

class SeoController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_SETTINGS');
    }

    public function index()
    {
        if (get('tab') == null) {
          redirect('?tab=404');
        }

        $seoPages = db()->query("SELECT * FROM SeoPages");
        $seoPages = $seoPages->fetchAll();

        $seoPage = db()->prepare("SELECT * FROM SeoPages WHERE page = ?");
        $seoPage->execute(array(get('tab')));
        $seoPage = $seoPage->fetch();

        return view('settings.seo.index', compact('seoPages', 'seoPage'));
    }

    public function update($id)
    {
        validate([
            'title' => 'required',
            'description' => 'nullable',
            'image' => 'nullable',
        ]);

        $updateSettings = db()->prepare("UPDATE SeoPages SET title = ?, description = ?, image = ? WHERE id = ?");
        $updateSettings->execute(array(input('title'), input('description'), input('image'), $id));

        createLog("SEO_SETTINGS_UPDATED");

        return back()->flash("success", t__('Changes has been saved successfully!'));
    }
}