<?php

namespace Dashboard\Controllers\Settings;

use Dashboard\Core\Controller;

class SmtpController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_SETTINGS');
    }

    public function index()
    {
        return view('settings.smtp.index');
    }

    public function update()
    {
        validate([
            'smtpServer' => 'required',
            'smtpPort' => 'required',
            'smtpSecure' => 'required',
            'smtpSenderEmail' => 'required',
            'smtpUsername' => 'required',
            'smtpPassword' => 'required',
        ]);

        foreach ($_POST as $key => $value) {
            $updateSettings = db()->prepare("UPDATE Settings SET value = ? WHERE name = ?");
            $updateSettings->execute([input($key), $key]);
        }
        createLog("SMTP_SETTINGS_UPDATED");
				
        return back()->flash("success", t__('Changes has been saved successfully!'));
    }
}