<?php

namespace Dashboard\Controllers\Settings;

use Dashboard\Core\Controller;

class StoreController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_SETTINGS');
    }

    public function index()
    {
        return view('settings.store.index');
    }

    public function update()
    {
        $module = db()->prepare("SELECT * FROM Modules WHERE slug = ?");
        $module->execute(['store']);
        $module = $module->fetch();
        if (!$module) {
            abort_404();
        }
	    
		    if (input("storeRedirectionStatus") == 0) {
			    set_input("redirect", '');
		    }
		    if (input("cashbackStatus") == 0) {
			    set_input("cashback", 0);
		    }
		    if (input("taxStatus") == 0) {
			    set_input("tax", 0);
		    }
				
				if (input('cashback') == '') {
					set_input('cashback', 0);
				}
				
		    if (input("tax") == 0) {
			    set_input("tax", 0);
				}
		    
		    set_input("cashback", str_replace('%', '', input("cashback")));
		    set_input("tax", str_replace('%', '', input("tax")));

        foreach ($_POST as $key => $value) {
            $updateSettings = db()->prepare("UPDATE ModuleSettings SET value = ? WHERE name = ? AND moduleID = ?");
            $updateSettings->execute([input($key), $key, $module['id']]);
        }
        createLog("STORE_SETTINGS_UPDATED");

        return back()->flash("success", t__('Changes has been saved successfully!'));

    }
}