<?php

namespace Dashboard\Controllers\Settings;

use Dashboard\Core\Controller;

class SupportController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_SETTINGS');
    }

    public function index()
    {
        return view('settings.support.index');
    }

    public function update()
    {
      $module = db()->prepare("SELECT * FROM Modules WHERE slug = ?");
      $module->execute(['support']);
      $module = $module->fetch();
      if (!$module) {
          abort_404();
      }
	    
	    if (input('unlimitedTicketsLimit')) {
		    set_input('ticketsLimit', -1);
		    $_POST['ticketsLimit'] = -1;
	    }
	    
    $supportMessageTemplateCheckMessage = strpos($_POST["messageTemplate"], "%message%");
    
    if ($supportMessageTemplateCheckMessage == false) {
	    return back()->flash('error', t__('Please add %message% parameter to Support Message Template'));
    }

      foreach ($_POST as $key => $value) {
          $updateSettings = db()->prepare("UPDATE ModuleSettings SET value = ? WHERE name = ? AND moduleID = ?");
          $updateSettings->execute([input($key), $key, $module['id']]);
      }
      createLog("SUPPORT_SETTINGS_UPDATED");

      return back()->flash("success", t__('Changes has been saved successfully!'));

    }
}