<?php

namespace Dashboard\Controllers\Settings;

use Dashboard\Core\Controller;

class SystemController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_SETTINGS');
    }

    public function index()
    {
        $zoneIdentifiers = timezone_identifiers_list();
        $zoneLocations = array();

        return view('settings.system.index', compact('zoneIdentifiers', 'zoneLocations'));
    }

    public function update()
    {
		    if (input('unlimitedRegisterLimit')) {
			    set_input('registerLimit', -1);
					$_POST['registerLimit'] = -1;
		    }
				
        foreach ($_POST as $key => $value) {
            $updateSettings = db()->prepare("UPDATE Settings SET value = ? WHERE name = ?");
            $updateSettings->execute([input($key), $key]);
        }
        createLog("SYSTEM_SETTINGS_UPDATED");

        return back()->flash("success", t__('Changes has been saved successfully!'));
    }
}