<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;
use Verot\Upload\Upload;

class SliderController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_SLIDER');
    }

    public function index()
    {
        $sliderItems = db()->query("SELECT * FROM Slider ORDER BY id ASC");
        $sliderItems = $sliderItems->fetchAll();

        return view('sliders.index', compact('sliderItems'));
    }

    public function create()
    {
        return view('sliders.create');
    }

    public function store()
    {
        validate([
            'title' => 'required',
            'content' => 'required',
            'url' => 'required',
            'image' => 'required|uploaded_file',
        ]);

        $upload = new Upload($_FILES["image"]);
        $imageID = md5(uniqid(rand(0, 9999)));
        if ($upload->uploaded) {
            $upload->allowed = array("image/*");
            $upload->file_new_name_body = $imageID;
            $upload->process(__ROOT__ . "/apps/main/public/images/slider/");
            if ($upload->processed) {
                $insertSlider = db()->prepare("INSERT INTO Slider (title, content, url, imageID, imageType) VALUES (?, ?, ?, ?, ?)");
                $insertSlider->execute(array(input("title"), input("content"), input("url"), $imageID, $upload->file_dst_name_ext));
                return back()->flash("success", t__('Slider has been added successfully!'));
            }
        } else {
            return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
        }
    }

    public function edit($id)
    {
        $sliderItem = db()->prepare("SELECT * FROM Slider WHERE id = ?");
        $sliderItem->execute(array($id));
        $sliderItem = $sliderItem->fetch();

      if (!$sliderItem) return view('404');

        return view('sliders.edit', compact('sliderItem'));
    }

    public function update($id)
    {
        validate([
            'title' => 'required',
            'content' => 'required',
            'url' => 'required',
        ]);
				
        if (input()->file('image')->size) {
            $upload = new Upload($_FILES["image"]);
            $imageID = md5(uniqid(rand(0, 9999)));
            if ($upload->uploaded) {
                $upload->allowed = array("image/*");
                $upload->file_overwrite = true;
                $upload->file_new_name_body = $imageID;
                $upload->process(__ROOT__ . "/apps/main/public/images/slider/");
                if ($upload->processed) {
                    $updateSlider = db()->prepare("UPDATE Slider SET imageID = ?, imageType = ? WHERE id = ?");
                    $updateSlider->execute(array($imageID, $upload->file_dst_name_ext, $id));
                } else {
                    return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
                }
            }
        }

        $updateSlider = db()->prepare("UPDATE Slider SET title = ?, content = ?, url = ? WHERE id = ?");
        $updateSlider->execute(array(input("title"), input("content"), input("url"), $id));
        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $deleteSlider = db()->prepare("DELETE FROM Slider WHERE id = ?");
        $deleteSlider->execute(array($id));
        return back();
    }
}