<?php

namespace Dashboard\Controllers\Store;

use Dashboard\Core\Controller;

class BulkDiscountController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_STORE');
    }

    public function index()
    {
        return view('store.bulk-discount.index');
    }

    public function update()
    {
        $validateRules = [
	        'storeDiscountStatus' => 'required',
	        'storeDiscount' => 'required_if:storeDiscountStatus,1',
	        'storeDiscountProductStatus' => 'required_if:storeDiscountStatus,1',
	        'storeDiscountProducts' => 'required_if:storeDiscountProductStatus,1',
        ];
				
				if (input('storeDiscountStatus') == '1' && !input("neverExpires")) {
				    $validateRules['expiryDate'] = 'required';
				}
				
				validate($validateRules);
				
		    if (input("neverExpires")) {
			      set_input("expiryDate", '1000-01-01 00:00:00');
		    }
        if (input("storeDiscountProductStatus") == 0) {
            set_input('storeDiscountProducts', 0);
        }
	    
		    if (input("storeDiscountStatus") == 0) {
				    set_input('storeDiscount', 0);
				    set_input("expiryDate", '1000-01-01 00:00:00');
				    set_input('storeDiscountProducts', 0);
		    }

        updateModuleSettings('store', [
            "discount" => input("storeDiscount"),
            "discountExpiryDate" => input("expiryDate"),
            "discountProducts" => input("storeDiscountProducts")
        ]);

        return back()->flash('success', t__('Changes has been saved successfully!'));
    }
}