<?php

namespace Dashboard\Controllers\Store;

use Dashboard\Core\Controller;
use Dashboard\Services\CacheService;
use Dashboard\Services\CategoryService;
use Dashboard\Services\ProductService;
use Dashboard\Services\SlugService;
use PDO;
use Verot\Upload\Upload;

class CategoryController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_STORE');
    }

    public function index()
    {
        $categories = db()->query("SELECT PC.*, PPC.name as parentCategoryName FROM ProductCategories PC LEFT JOIN ProductCategories PPC ON PPC.id = PC.parentID ORDER BY PC.priority DESC, PC.id DESC");
        $categories = $categories->fetchAll();

        return view('store.categories.index', compact('categories'));
    }

    public function create()
    {
        $categories = db()->query("SELECT id, name, parentID FROM ProductCategories");
        $categories = $categories->fetchAll(PDO::FETCH_ASSOC);
        $categoryList = [];
        $categoryList[] = [
            "id" => 0,
            "name" => t__("No parent category"),
            "parentID" => 0,
            "subCategories" => []
        ];
        $categoryList = array_merge($categoryList, CategoryService::buildTree($categories));
	    
		    $products = db()->query("SELECT id, name, categoryID FROM Products ORDER BY priority DESC");
		    $products = $products->fetchAll(PDO::FETCH_ASSOC);
		    
		    $productList = ProductService::buildTree($categories, $products);

        return view('store.categories.create', compact('categoryList', 'productList'));
    }

    public function store()
    {
        validate([
            'name' => 'required',
            'parentID' => 'required',
            'minecraftStatus' => 'required',
            'minecraftTitle' => 'nullable',
            'minecraftDescription' => 'nullable',
            'minecraftItem' => 'required_if:minecraftStatus,1',
	          'minecraftItemModelID' => 'nullable',
            'priority' => 'required',
            'image' => 'required|uploaded_file',
            'isActive' => 'required',
            'isCumulative' => 'required',
	          'requiredProducts' => 'nullable|array'
        ]);

        $upload = new Upload($_FILES["image"]);
        $imageID = md5(uniqid(rand(0, 9999)));

        if ($upload->uploaded) {
            $upload->allowed = array("image/*");
            $upload->file_new_name_body = $imageID;
            $upload->process(__ROOT__ . "/apps/main/public/images/store/categories/");
            if ($upload->processed) {
	              $slug = SlugService::preventDuplicate(input("name"));
                $insertProductCategories = db()->prepare("INSERT INTO ProductCategories (parentID, name, slug, imageID, imageType, priority, minecraftStatus, minecraftTitle, minecraftDescription, minecraftItem, minecraftItemModelID, isActive, isCumulative) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $insertProductCategories->execute(array(input("parentID"), input("name"), $slug, $imageID, $upload->file_dst_name_ext, input("priority"), input("minecraftStatus"), input("minecraftTitle"), input("minecraftDescription"), input("minecraftItem"), input("minecraftItemModelID"), input("isActive"), input("isCumulative")));
								$categoryID = db()->lastInsertId();
	            
		            $requiredProducts = input("requiredProducts");
		            if ($requiredProducts) {
									$insertRequiredProducts = db()->prepare("INSERT INTO ProductCategoryRequiredProducts (categoryID, productID) VALUES (?, ?)");
									foreach ($requiredProducts as $requiredProductsID) {
										$insertRequiredProducts->execute(array($categoryID, $requiredProductsID));
									}
								}
								
								CacheService::updateStoreCategoryTree();
								
                return back()->flash("success", t__('Category has been added successfully!'));
            }
        } else {
            return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
        }
    }

    public function edit($id)
    {
        $category = db()->prepare("SELECT PC.* FROM ProductCategories PC WHERE PC.id = ?");
        $category->execute(array($id));
        $category = $category->fetch();

        if (!$category) return view('404');

        $categories = db()->query("SELECT id, name, parentID FROM ProductCategories");
        $categories = $categories->fetchAll(PDO::FETCH_ASSOC);
        $categoryList = [];
        $categoryList[] = [
          "id" => 0,
          "name" => t__("No parent category"),
          "parentID" => 0,
          "subCategories" => []
        ];
        $categoryList = array_merge($categoryList, CategoryService::buildTree($categories));
	    
		    $products = db()->query("SELECT id, name, categoryID FROM Products ORDER BY priority DESC");
		    $products = $products->fetchAll(PDO::FETCH_ASSOC);
		    
		    $productList = ProductService::buildTree($categories, $products);
				
				$requiredProducts = db()->prepare("SELECT productID FROM ProductCategoryRequiredProducts WHERE categoryID = ?");
				$requiredProducts->execute(array($id));
				$requiredProducts = $requiredProducts->fetchAll(PDO::FETCH_COLUMN);
				$category["requiredProducts"] = $requiredProducts;

        return view('store.categories.edit', compact('category', 'categoryList', 'productList'));
    }

    public function update($id)
    {
        validate([
            'name' => 'required',
            'parentID' => 'required',
            'minecraftStatus' => 'required',
            'minecraftTitle' => 'nullable',
            'minecraftDescription' => 'nullable',
            'minecraftItem' => 'required_if:minecraftStatus,1',
	          'minecraftItemModelID' => 'nullable',
            'priority' => 'required',
            'isActive' => 'required',
            'isCumulative' => 'required',
	          'requiredProducts' => 'nullable|array'
        ]);
	    
		    $category = db()->prepare("SELECT * FROM ProductCategories WHERE id = ?");
		    $category->execute(array($id));
		    $category = $category->fetch();
				
				if (!$category) return view('404');

        if (input()->file('image')->size) {
            $upload = new Upload($_FILES["image"]);
            $imageID = md5(uniqid(rand(0, 9999)));
            if ($upload->uploaded) {
                $upload->allowed = array("image/*");
                $upload->file_overwrite = true;
                $upload->file_new_name_body = $imageID;
                $upload->process(__ROOT__ . "/apps/main/public/images/store/categories/");
                if ($upload->processed) {
                    $updateProductCategories = db()->prepare("UPDATE ProductCategories SET imageID = ?, imageType = ? WHERE id = ?");
                    $updateProductCategories->execute(array($imageID, $upload->file_dst_name_ext, $id));
                } else {
                    return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
                }
            }
        }
	    
		    if ($category["name"] != input("name")) {
			    $slug = SlugService::preventDuplicate(input("name"));
		    } else {
			    $slug = $category["slug"];
		    }
				
        $updateProductCategories = db()->prepare("UPDATE ProductCategories SET parentID = ?, name = ?, slug = ?, priority = ?, minecraftStatus = ?, minecraftTitle = ?, minecraftDescription = ?, minecraftItem = ?, minecraftItemModelID = ?, isActive = ?, isCumulative = ? WHERE id = ?");
        $updateProductCategories->execute(array(input("parentID"), input("name"), $slug, input("priority"), input("minecraftStatus"), input("minecraftTitle"), input("minecraftDescription"), input("minecraftItem"), input("minecraftItemModelID"), input("isActive"), input("isCumulative"), $id));
				
				$requiredProducts = input("requiredProducts");
		    $deleteRequiredProducts = db()->prepare("DELETE FROM ProductCategoryRequiredProducts WHERE categoryID = ?");
		    $deleteRequiredProducts->execute(array($id));
				if ($requiredProducts) {
					$insertRequiredProducts = db()->prepare("INSERT INTO ProductCategoryRequiredProducts (categoryID, productID) VALUES (?, ?)");
					foreach ($requiredProducts as $requiredProductsID) {
						$insertRequiredProducts->execute(array($id, $requiredProductsID));
					}
				}
	    
		    CacheService::updateStoreCategoryTree();

        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $deleteProductCategory = db()->prepare("DELETE FROM ProductCategories WHERE id = ?");
        $deleteProductCategory->execute(array($id));
        return back();
    }
}