<?php

namespace Dashboard\Controllers\Store;

use Dashboard\Core\Controller;
use Dashboard\Services\ProductService;
use PDO;

class ChestSendController extends Controller
{
    public function __construct()
    {
        abort_perm(['MANAGE_STORE', 'MANAGE_ACCOUNTS']);
    }

    public function index()
    {
        $account = null;
        if (get("id")) {
          $account = db()->prepare("SELECT * FROM Accounts WHERE id = :user OR username = :user");
          $account->execute(array(
            'user' => get("id")
          ));
          $account = $account->fetch();
        }

        $categories = db()->query("SELECT id, name, parentID FROM ProductCategories ORDER BY priority DESC");
        $categories = $categories->fetchAll(PDO::FETCH_ASSOC);

        $products = db()->query("SELECT id, name, categoryID FROM Products ORDER BY priority DESC");
		    $products = array_map(function ($product) {
			    // Exclude products that have variables
			    $variables = db()->prepare("SELECT V.id FROM ProductVariables PV INNER JOIN StoreVariables V ON PV.variableID = V.id WHERE PV.productID = ?");
			    $variables->execute(array($product["id"]));
			    if ($variables->rowCount() > 0) {
				    return null;
			    }
			    
			    return $product;
		    }, $products->fetchAll(PDO::FETCH_ASSOC));
		    $products = array_filter($products);

        $productList = ProductService::buildTree($categories, $products);

        return view('store.chest.send.index', compact('account', 'productList'));
    }

    public function send() {
        validate([
            'userID' => 'required',
            'productID' => 'required',
            'amount' => 'required',
        ]);

        $account = db()->prepare("SELECT * FROM Accounts WHERE id = ?");
        $account->execute(array(input("userID")));
        $account = $account->fetch();

        if (!$account) {
            return back()->flash("error", t__('User not found!'));
        }

        $product = db()->prepare("SELECT * FROM Products WHERE id = ?");
        $product->execute(array(input("productID")));
        $product = $product->fetch();

        if (!$product) {
            return back()->flash("error", t__('Product not found!'));
        }

        for ($i = 0; $i < input("amount"); $i++) {
            $insertChests = db()->prepare("INSERT INTO Chests (accountID, productID, status, creationDate) VALUES (?, ?, ?, ?)");
            $insertChests->execute(array($account["id"], input("productID"), 0, datetime()));
        }

        createLog('CHEST_ITEM_SENT', [
            'username' => $account["realname"],
            'product' => $product["name"],
            'productID' => $product["id"],
            'amount' => input("amount"),

        ]);

        return back()->flash('success', t__('Product has been sent successfully!'));
    }
}