<?php

namespace Dashboard\Controllers\Store;

use Dashboard\Core\Controller;
use Dashboard\Services\CategoryService;
use PDO;
use Verot\Upload\Upload;

class CommunityGoalController extends Controller
{
  public function __construct()
  {
    abort_perm('MANAGE_COMMUNITY_GOALS');
  }

  public function index()
  {
    return view('store.community-goals.index');
  }

  public function update()
  {
    validate([
      'communityGoalStatus' => 'required',
      'communityGoalTitle' => 'required_if:communityGoalStatus,1',
      'communityGoalDescription' => 'required_if:communityGoalStatus,1',
      'communityGoalCurrent' => 'required_if:communityGoalStatus,1',
      'communityGoalTarget' => 'required_if:communityGoalStatus,1',
      'communityGoalRepeat' => 'required_if:communityGoalRepeat,1',
    ]);

    if (input("communityGoalStatus") == 0) {
      set_input('communityGoalCurrent', 0);
    }

    updateModuleSettings('store', [
      "communityGoalStatus" => input("communityGoalStatus"),
      "communityGoalTitle" => input("communityGoalTitle"),
      "communityGoalDescription" => input("communityGoalDescription"),
      "communityGoalCurrent" => input("communityGoalCurrent"),
      "communityGoalTarget" => input("communityGoalTarget"),
      "communityGoalRepeat" => input("communityGoalRepeat")
    ]);

    return back()->flash('success', t__('Changes has been saved successfully!'));
  }
}