<?php

namespace Dashboard\Controllers\Store;

use Dashboard\Core\Controller;
use PDO;

class CouponLogController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_STORE');
    }

    public function index()
    {
        if (isset($_GET["page"])) {
            if (!is_numeric($_GET["page"])) {
                $_GET["page"] = 1;
            }
            $page = intval(get("page"));
        } else {
            $page = 1;
        }

        $visiblePageCount = 5;
        $limit = 50;

        $couponLogs = db()->query("SELECT count(PCH.id) FROM ProductCouponsHistory PCH INNER JOIN Accounts A ON PCH.accountID = A.id INNER JOIN ProductCoupons PC ON PCH.couponID = PC.id INNER JOIN Orders O ON PCH.productID = O.id");
        $itemsCount = $couponLogs->fetchColumn();
        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;
        $couponLogs = db()->query("SELECT PCH.*, A.username, A.realname, PC.name as couponName FROM ProductCouponsHistory PCH INNER JOIN Accounts A ON PCH.accountID = A.id INNER JOIN ProductCoupons PC ON PCH.couponID = PC.id INNER JOIN Orders O ON PCH.productID = O.id ORDER BY PCH.id DESC LIMIT $visibleItemsCount, $limit");


        if (isset($_GET["search"])) {
            if (get("search") != null) {
                $couponLogs = db()->prepare("SELECT PCH.*, A.username, A.realname, PC.name as couponName FROM ProductCouponsHistory PCH INNER JOIN Accounts A ON PCH.accountID = A.id INNER JOIN ProductCoupons PC ON PCH.couponID = PC.id INNER JOIN Orders O ON PCH.productID = O.id WHERE (A.realname LIKE :search OR A.username LIKE :search) ORDER BY PCH.id DESC");
                $couponLogs->execute(array(
                    "search" => '%' . get("search") . '%'
                ));
            }
        }

        $couponLogs = $couponLogs->fetchAll(PDO::FETCH_ASSOC);

        return view('store.coupon-logs.index', compact('couponLogs', 'page', 'visiblePageCount', 'pageCount'));
    }

    public function destroy($id)
    {
        $deleteProductCouponsHistory = db()->prepare("DELETE FROM ProductCouponsHistory WHERE id = ?");
        $deleteProductCouponsHistory->execute(array($id));
        return back();
    }
}