<?php

namespace Dashboard\Controllers\Store;

use Dashboard\Core\Controller;
use PDO;
use Verot\Upload\Upload;

class CreditPackageController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_STORE');
    }

    public function index()
    {
        $packages = db()->prepare("SELECT * FROM CreditPackages ORDER BY id DESC");
        $packages->execute(array(0));
        $packages = $packages->fetchAll(PDO::FETCH_ASSOC);

        return view('store.credit-packages.index', compact('packages'));
    }

    public function create()
    {
        return view('store.credit-packages.create');
    }

    public function store()
    {
        validate([
            'name' => 'required',
            'bonus' => 'required',
            'details' => 'required',
            'price' => 'required',
            'amount' => 'required',
            'discountStatus' => 'required',
            'discountedPrice' => 'required_if:discountStatus,1',
            'discountDurationStatus' => 'required',
            'discountDuration' => 'required_if:discountDurationStatus,1',
            'stockStatus' => 'required',
            'stock' => 'required_if:stockStatus,1',
            'image' => 'required|uploaded_file',
        ]);

        if (input("stockStatus") == 0) {
          set_input("stock", -1);
        }
        if (input("discountStatus") == 0) {
          set_input("discountedPrice", 0);
        }
        if (input("discountDurationStatus") == 0 || input("discountStatus") == 0) {
          set_input("discountDuration", '1000-01-01 00:00:00');
        } else {
          set_input("discountDuration", date("Y-m-d H:i:s", strtotime($_POST["discountDuration"])));
        }

        $upload = new Upload($_FILES["image"]);
        $imageID = md5(uniqid(rand(0, 9999)));
        if ($upload->uploaded) {
            $upload->allowed = array("image/*");
            $upload->file_new_name_body = $imageID;
            $upload->process(__ROOT__ . "/apps/main/public/images/store/products/");
            if ($upload->processed) {
                $insertProducts = db()->prepare("INSERT INTO CreditPackages (name, imageID, imageType, details, amount, price, bonus, discountedPrice, discountExpiryDate, stock, creationDate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $insertProducts->execute(array(input("name"), $imageID, $upload->file_dst_name_ext, filteredContent($_POST["details"]), input("amount"), input("price"), input("bonus"), input("discountedPrice"), input("discountDuration"), input("stock"), datetime()));
                return back()->flash("success", t__('Credit Package has been added successfully!'));
            }
        } else {
            return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
        }
    }

    public function edit($id)
    {
        $package = db()->prepare("SELECT * FROM CreditPackages WHERE id = ?");
        $package->execute(array($id));
        $package = $package->fetch();

        if (!$package) return view('404');

        return view('store.credit-packages.edit', compact('package'));
    }

    public function update($id)
    {
        validate([
            'name' => 'required',
            'bonus' => 'required',
            'details' => 'required',
            'price' => 'required',
            'amount' => 'required',
            'discountStatus' => 'required',
            'discountedPrice' => 'required_if:discountStatus,1',
            'discountDurationStatus' => 'required',
            'discountDuration' => 'required_if:discountDurationStatus,1',
            'stockStatus' => 'required',
            'stock' => 'required_if:stockStatus,1',
        ]);

        if (input("stockStatus") == 0) {
            set_input("stock", -1);
        }
        if (input("discountStatus") == 0) {
            set_input("discountedPrice", 0);
        }
        if (input("discountDurationStatus") == 0 || input("discountStatus") == 0) {
            set_input("discountDuration", '1000-01-01 00:00:00');
        } else {
            set_input("discountDuration", date("Y-m-d H:i:s", strtotime($_POST["discountDuration"])));
        }

        if (input()->file('image')->size) {
            $upload = new Upload($_FILES["image"]);
            $imageID = md5(uniqid(rand(0, 9999)));
            if ($upload->uploaded) {
                $upload->allowed = array("image/*");
                $upload->file_overwrite = true;
                $upload->file_new_name_body = $imageID;
                $upload->process(__ROOT__ . "/apps/main/public/images/store/products/");
                if ($upload->processed) {
                    $updateProducts = db()->prepare("UPDATE CreditPackages SET imageID = ?, imageType = ? WHERE id = ?");
                    $updateProducts->execute(array($imageID, $upload->file_dst_name_ext, $id));
                } else {
                    return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
                }
            }
        }

        $updateProducts = db()->prepare("UPDATE CreditPackages SET name = ?, details = ?, amount = ?, price = ?, bonus = ?, discountedPrice = ?, discountExpiryDate = ?, stock = ? WHERE id = ?");
        $updateProducts->execute(array(input("name"), filteredContent($_POST["details"]), input("amount"), input("price"), input("bonus"), input("discountedPrice"), input("discountDuration"), input("stock"), $id));
        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $deleteProduct = db()->prepare("DELETE FROM CreditPackages WHERE id = ?");
        $deleteProduct->execute(array($id));
        return back();
    }
}