<?php

namespace Dashboard\Controllers\Store;

use Dashboard\Core\Controller;
use PDO;

class CreditPurchaseLogController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_STORE');
    }

    public function index()
    {
        if (isset($_GET["page"])) {
            if (!is_numeric($_GET["page"])) {
                $_GET["page"] = 1;
            }
            $page = intval(get("page"));
        } else {
            $page = 1;
        }

        $visiblePageCount = 5;
        $limit = 50;

        $creditPurchaseLogs = db()->prepare("SELECT count(CH.id) FROM CreditHistory CH INNER JOIN Accounts A ON CH.accountID = A.id WHERE CH.type = ?");
        $creditPurchaseLogs->execute(array(1));
        $itemsCount = $creditPurchaseLogs->fetchColumn();
        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;
        $creditPurchaseLogs = db()->prepare("SELECT CH.*, A.username, A.realname FROM CreditHistory CH INNER JOIN Accounts A ON CH.accountID = A.id WHERE CH.type = ? ORDER BY CH.id DESC LIMIT $visibleItemsCount, $limit");
        $creditPurchaseLogs->execute(array(1));

        if (isset($_GET["search"])) {
            if (get("search") != null) {
                $creditPurchaseLogs = db()->prepare("SELECT CH.*, A.username, A.realname FROM CreditHistory CH INNER JOIN Accounts A ON CH.accountID = A.id WHERE (A.realname LIKE :search OR A.username LIKE :search) AND CH.type = :chargeType ORDER BY CH.id DESC");
                $creditPurchaseLogs->execute(array(
                    "search" => '%' . get("search") . '%',
                    "chargeType" => 1,
                ));
            }
        }

        $creditPurchaseLogs = $creditPurchaseLogs->fetchAll(PDO::FETCH_ASSOC);

        return view('store.credit-purchase-logs.index', compact('creditPurchaseLogs', 'page', 'visiblePageCount', 'pageCount'));
    }

    public function destroy($id)
    {
        $deleteCreditHistory = db()->prepare("DELETE FROM CreditHistory WHERE id = ?");
        $deleteCreditHistory->execute(array($id));
        return back();
    }
}