<?php

namespace Dashboard\Controllers\Store;

use Dashboard\Core\Controller;
use Dashboard\Core\Jobs\JobDispatcher;
use Dashboard\Jobs\SendDiscordWebhook;

class CreditSendController extends Controller
{
    public function __construct()
    {
        abort_perm(['MANAGE_STORE', 'MANAGE_ACCOUNTS']);
    }

    public function index()
    {
        $account = null;
        if (get("id")) {
          $account = db()->prepare("SELECT * FROM Accounts WHERE id = :user OR username = :user");
          $account->execute(array(
            'user' => get("id")
          ));
          $account = $account->fetch();
        }

        return view('store.credit.send.index', compact('account'));
    }
		
  public function send()
    {
        validate([
            'userID' => 'required',
            'amount' => 'required',
            'isEarnings' => 'required|boolean'
        ]);
				
				$isEarnings = input('isEarnings');
				$amount = input('amount');

        $account = db()->prepare("SELECT * FROM Accounts WHERE id = ?");
        $account->execute(array(input("userID")));
        $account = $account->fetch();

        if (!$account) {
            return back()->flash("error", t__('User not found!'));
        }

        $insertCreditHistory = db()->prepare("INSERT INTO CreditHistory (accountID, type, price, creationDate) VALUES (?, ?, ?, ?)");
        $insertCreditHistory->execute(array($account["id"], 1, $amount, datetime()));

        $createOrder = db()->prepare("INSERT INTO Orders (accountID, coupon, total, discount, subtotal, tax, paymentID, paymentAPI, status, type, credit, earnings, creationDate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $createOrder->execute(array(
          $account["id"],
          null,
	        $amount,
          0,
	        $amount,
					0,
          "",
          "manual",
          1,
          2,
          0,
          $isEarnings ? $amount : 0,
          date("Y-m-d H:i:s")
        ));
				
				// Update community goal if is earnings
				if ($isEarnings) {
					if (moduleSettings('store', 'communityGoalStatus', '0') == '1') {
						$newCommunityGoalValue = moduleSettings('store', 'communityGoalCurrent', '0') + $amount;
						if ($newCommunityGoalValue >= moduleSettings('store', 'communityGoalTarget')) {
							$newCommunityGoalValue = 0;
							if (moduleSettings('store', 'communityGoalRepeat', '0') == '0') {
								updateModuleSettings('store', [
									'communityGoalStatus' => '0'
								]);
							}
						}
						updateModuleSettings('store', [
							'communityGoalCurrent' => $newCommunityGoalValue
						]);
					}
				}

        $updateAccounts = db()->prepare("UPDATE Accounts SET credit = credit + ? WHERE id = ?");
        $updateAccounts->execute(array($amount, $account["id"]));
				
				JobDispatcher::dispatch((new SendDiscordWebhook('store.purchase.credit', [
					"username" => $account["realname"],
					"credit" => $amount,
					"currency" => settings('currency'),
				])));

        createLog('CREDITS_SENT', [
          'username' => $account["realname"],
          'amount' => $amount
        ]);

        return back()->flash('success', t__('The credit has been sent successfully!'));
    }
}