<?php

namespace Dashboard\Controllers\Store;

use Dashboard\Core\Controller;

class CreditUsageLogController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_STORE');
    }

    public function index()
    {
        if (isset($_GET["page"])) {
            if (!is_numeric($_GET["page"])) {
                $_GET["page"] = 1;
            }
            $page = intval(get("page"));
        } else {
            $page = 1;
        }

        $visiblePageCount = 5;
        $limit = 50;

        $creditUsageLogs = db()->prepare("SELECT count(CH.id) FROM CreditHistory CH INNER JOIN Accounts A ON CH.accountID = A.id WHERE CH.type != ?");
        $creditUsageLogs->execute(array(1));
        $itemsCount = $creditUsageLogs->fetchColumn();
        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;
        $creditUsageLogs = db()->prepare("SELECT CH.*, A.username, A.realname, OA.realname as otherAccountUsername FROM CreditHistory CH INNER JOIN Accounts A ON CH.accountID = A.id LEFT JOIN Accounts OA ON OA.id = CH.otherAccountID WHERE CH.type != ? ORDER BY CH.id DESC LIMIT $visibleItemsCount, $limit");
        $creditUsageLogs->execute(array(1));

        if (isset($_GET["search"])) {
            if (get("search") != null) {
                $creditUsageLogs = db()->prepare("SELECT CH.*, A.username, A.realname, OA.realname as otherAccountUsername FROM CreditHistory CH INNER JOIN Accounts A ON CH.accountID = A.id LEFT JOIN Accounts OA ON OA.id = CH.otherAccountID WHERE (A.realname LIKE :search OR A.username LIKE :search) AND CH.type != :chargeType ORDER BY CH.id DESC");
                $creditUsageLogs->execute(array(
                    "search" => '%' . get("search") . '%',
                    "chargeType" => 1,
                ));
            }
        }

        $creditUsageLogs = $creditUsageLogs->fetchAll();

        return view('store.credit-usage-logs.index', compact('creditUsageLogs', 'page', 'visiblePageCount', 'pageCount'));
    }

    public function destroy($id)
    {
        $deleteCreditHistory = db()->prepare("DELETE FROM CreditHistory WHERE id = ?");
        $deleteCreditHistory->execute(array($id));
        return back();
    }
}