<?php

namespace Dashboard\Controllers\Store;

use Curl\Curl;
use Dashboard\Core\Controller;
use PDO;

class PaymentController extends Controller
{
    public function __construct()
    {
        abort_perm(['MANAGE_STORE', ['MANAGE_PAYMENT']]);
    }

    public function index()
    {
        if (isset($_GET["page"])) {
            if (!is_numeric($_GET["page"])) {
                $_GET["page"] = 1;
            }
            $page = intval(get("page"));
        } else {
            $page = 1;
        }

        $visiblePageCount = 5;
        $limit = 50;
	    
		    $status = null;
		    if (isset($_GET["status"])) {
			    $status = get("status");
		    }

        $payments = db()->query("SELECT count(id) FROM Orders WHERE paymentAPI != 'credit' AND earnings > 0");
        $itemsCount = $payments->fetchColumn();
        $pageCount = ceil($itemsCount / $limit);
        if ($page > $pageCount) {
            $page = 1;
        }
        $visibleItemsCount = $page * $limit - $limit;
        $payments = db()->query("SELECT O.*, A.username, A.realname FROM Orders O INNER JOIN Accounts A ON O.accountID = A.id WHERE paymentAPI != 'credit' AND earnings > 0 ORDER BY O.id DESC LIMIT $visibleItemsCount, $limit");

        if (isset($_GET["search"])) {
            if (get("search") != null) {
                $payments = db()->prepare("SELECT O.*, A.username, A.realname FROM Orders O INNER JOIN Accounts A ON O.accountID = A.id WHERE (A.realname LIKE :search OR A.username LIKE :search) AND paymentAPI != 'credit' AND earnings > 0 ORDER BY O.id DESC");
                $payments->execute(array(
                    "search" => '%' . get("search") . '%'
                ));
            }
        } else if (isset($_GET["status"])) {
	        if ($status == "success") {
		        $payments = db()->query("SELECT O.*, A.username, A.realname FROM Orders O INNER JOIN Accounts A ON O.accountID = A.id WHERE O.status = 1 AND O.paymentAPI != 'credit' AND O.earnings > 0 ORDER BY O.id DESC");
	        }
	        if ($status == "waiting") {
		        $payments = db()->query("SELECT O.*, A.username, A.realname FROM Orders O INNER JOIN Accounts A ON O.accountID = A.id WHERE O.status = 0 AND O.paymentAPI = 'manual' AND O.earnings > 0 ORDER BY O.id DESC");
	        }
	        if ($status == "error") {
		        $payments = db()->query("SELECT O.*, A.username, A.realname FROM Orders O INNER JOIN Accounts A ON O.accountID = A.id WHERE O.status = 0 AND O.paymentAPI != 'manual' AND O.paymentAPI != 'credit' AND O.earnings > 0 ORDER BY O.id DESC");
	        }
        }

        $payments = array_map(function ($payment) {
            $paymentGateway = db()->prepare("SELECT * FROM PaymentGateways WHERE slug = ?");
            $paymentGateway->execute(array($payment["paymentAPI"]));
            $paymentGateway = $paymentGateway->fetch(PDO::FETCH_ASSOC);

            $payment["paymentGateway"] = $paymentGateway ? $paymentGateway["name"] : $payment["paymentAPI"];

            return $payment;
        }, $payments->fetchAll(PDO::FETCH_ASSOC));

        return view('store.payments.index', compact('payments', 'page', 'visiblePageCount', 'pageCount'));
    }
}