<?php

namespace Dashboard\Controllers\Store;

use Dashboard\Core\Controller;
use Dashboard\Services\CacheService;
use Dashboard\Services\ProductService;
use PDO;
use Verot\Upload\Upload;

class ProductController extends Controller
{
    public function __construct()
    {
      abort_perm('MANAGE_STORE');
    }

    public function index()
    {
      $categories = db()->query("SELECT id, name, parentID FROM ProductCategories ORDER BY priority DESC");
      $categories = $categories->fetchAll(PDO::FETCH_ASSOC);

      $products = db()->query("SELECT id, name, categoryID, price, discountedPrice, discountExpiryDate FROM Products ORDER BY priority DESC");
      $products = $products->fetchAll(PDO::FETCH_ASSOC);

      $tree = ProductService::buildTree($categories, $products);

      return view('store.products.index', compact('tree'));
    }

    public function tableView()
    {
      $products = db()->query("SELECT P.*, PC.name as categoryName, PC.slug as categorySlug FROM Products P LEFT JOIN ProductCategories PC ON P.categoryID = PC.id GROUP BY P.id ORDER BY P.priority DESC, P.id DESC");
      $products = $products->fetchAll();

      return view('store.products.table', compact('products'));
    }

    public function create()
    {
        $servers = db()->query("SELECT * FROM Servers ORDER BY name ASC");
        $servers = $servers->fetchAll();

        $roles = db()->query("SELECT * FROM Roles ORDER BY priority DESC");
        $roles = $roles->fetchAll();
	    
		    $categories = db()->query("SELECT id, name, parentID FROM ProductCategories");
		    $categories = $categories->fetchAll(PDO::FETCH_ASSOC);
		    $products = db()->query("SELECT id, name, categoryID FROM Products ORDER BY priority DESC");
		    $products = $products->fetchAll(PDO::FETCH_ASSOC);
		    
		    $productList = ProductService::buildTree($categories, $products);
	    
		    $variables= db()->query("SELECT * FROM StoreVariables");
		    $variables = $variables->fetchAll();
				
				$accountLinkingProviders = [];
				if (!moduleIsDisabled('account_linking')) {
					$accountLinkingProviders = db()->prepare("SELECT * FROM AccountLinkingProviders WHERE isEnabled = ? AND slug != ?");
					$accountLinkingProviders->execute([1, settings('loginProvider')]);
					$accountLinkingProviders = $accountLinkingProviders->fetchAll();
				}

        return view('store.products.create', compact('servers', 'roles', 'variables', 'productList', 'accountLinkingProviders'));
    }

    public function store()
    {
        validate([
            'name' => 'required',
            'categoryID' => 'required',
            'details' => 'required',
            'price' => 'required',
            'discountStatus' => 'required',
            'discountedPrice' => 'required_if:discountStatus,1',
            'discountDurationStatus' => 'required_if:discountStatus,1',
            'discountDuration' => 'required_if:discountDurationStatus,1',
            'durationStatus' => 'required',
            'duration' => 'required_if:durationStatus,1',
            'stockStatus' => 'required',
            'stock' => 'required_if:stockStatus,1',
            'isFeaturedProduct' => 'required',
            'minecraftStatus' => 'required',
            'minecraftTitle' => 'nullable',
            'minecraftDescription' => 'nullable',
            'minecraftItem' => 'required_if:minecraftStatus,1',
		        'minecraftItemModelID' => 'nullable',
            'giveRoleID' => 'required',
            'priority' => 'required',
            'image' => 'nullable|uploaded_file',
		        'requiredLinkedAccounts' => 'nullable|array',
						'requiredProducts' => 'nullable|array',
						'requireOnlyOneProduct' => 'required',
						'disableGifting' => 'required',
						'disableQuantity' => 'required',
            'isActive' => 'required'
        ]);

        if (input("stockStatus") == 0) {
            set_input('stock', -1);
        }
        if (input("durationStatus") == 0) {
            set_input('duration', 0);
        }
        if (input("durationStatus") == -1) {
            set_input('duration', -1);
        }
        if (input("discountStatus") == 0) {
            set_input('discountedPrice', 0);
        }
        if (input("discountDurationStatus") == 0 || input("discountStatus") == 0) {
            set_input('discountDuration', '1000-01-01 00:00:00');
        } else {
            set_input('discountDuration', date("Y-m-d H:i:s", strtotime(input("discountDuration"))));
        }
				
				// If image is already uploaded
				if (input("imageID") && input("imageType")) {
					$imageID = input("imageID");
					$imageType = input("imageType");
				} else {
					if (input("image") == null) {
						return back()->flash("error", t__('Please select an image!'));
					}
					$upload = new Upload($_FILES["image"]);
					$imageID = md5(uniqid(rand(0, 9999)));
					if ($upload->uploaded) {
						$upload->allowed = array("image/*");
						$upload->file_new_name_body = $imageID;
						$upload->process(__ROOT__ . "/apps/main/public/images/store/products/");
						if ($upload->processed) {
							$imageType = $upload->file_dst_name_ext;
						} else {
							return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
						}
					} else {
						return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
					}
				}
	    
		    $insertProducts = db()->prepare("INSERT INTO Products (name, imageID, imageType, categoryID, details, price, discountedPrice, discountExpiryDate, duration, stock, priority, isFeaturedProduct, minecraftStatus, minecraftTitle, minecraftDescription, minecraftItem, minecraftItemModelID, giveRoleID, requireOnlyOneProduct, disableGifting, disableQuantity, isActive, creationDate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		    $insertProducts->execute(array(input("name"), $imageID, $imageType, input("categoryID"), filteredContent($_POST["details"]), input("price"), input("discountedPrice"), input("discountDuration"), input("duration"), input("stock"), input("priority"), input("isFeaturedProduct"), input("minecraftStatus"), input("minecraftTitle"), input("minecraftDescription"), input("minecraftItem"), input("minecraftItemModelID"), input("giveRoleID"), input("requireOnlyOneProduct"), input("disableGifting"), input("disableQuantity"), input("isActive"), datetime()));
		    $productsLastInsertID = db()->lastInsertId();
		    
		    if (count(array_filter($_POST["commands"]))) {
			    $insertProductCommands = db()->prepare("INSERT INTO ProductCommands (productID, serverID, command) VALUES (?, ?, ?)");
			    foreach ($_POST["commands"] as $key => $command) {
				    $command = ltrim($_POST["commands"][$key], '/');
				    $serverID = strip_tags($_POST["servers"][$key]);
				    $insertProductCommands->execute(array($productsLastInsertID, $serverID, $command));
			    }
		    }
	    
		    if (!moduleIsDisabled('account_linking')) {
			    $requiredLinkedAccounts = input("requiredLinkedAccounts");
			    if ($requiredLinkedAccounts) {
				    $insertRequiredLinkedAccounts = db()->prepare("INSERT INTO ProductRequiredLinkedAccounts (productID, requiredProviderID) VALUES (?, ?)");
				    foreach ($requiredLinkedAccounts as $requiredProviderID) {
					    $insertRequiredLinkedAccounts->execute(array($productsLastInsertID, $requiredProviderID));
				    }
			    }
	      }
				
				$requiredProducts = input("requiredProducts");
				if ($requiredProducts) {
					$insertRequiredProducts = db()->prepare("INSERT INTO ProductRequiredProducts (productID, requiredProductID) VALUES (?, ?)");
					foreach ($requiredProducts as $requiredProductsID) {
						$insertRequiredProducts->execute(array($productsLastInsertID, $requiredProductsID));
					}
				}
				
				$variables = input("variables");
				if ($variables) {
					$insertProductVariables = db()->prepare("INSERT INTO ProductVariables (productID, variableID) VALUES (?, ?)");
					foreach ($variables as $variableID) {
						$insertProductVariables->execute(array($productsLastInsertID, $variableID));
					}
				}
				
		    return back()->flash("success", t__('Product has been added successfully!'));
    }

    public function edit($id)
    {
        $product = db()->prepare("SELECT * FROM Products WHERE id = ?");
        $product->execute(array($id));
        $product = $product->fetch();

        if (!$product) return view('404');

        $servers = db()->query("SELECT * FROM Servers ORDER BY name ASC");
        $servers = $servers->fetchAll();

        $roles = db()->query("SELECT * FROM Roles ORDER BY priority DESC");

        $commands = db()->prepare("SELECT * FROM ProductCommands WHERE productID = ? AND isActive = ?");
        $commands->execute(array($product["id"], 1));
        $commands = $commands->fetchAll(PDO::FETCH_ASSOC);
	    
		    $categories = db()->query("SELECT id, name, parentID FROM ProductCategories");
		    $categories = $categories->fetchAll(PDO::FETCH_ASSOC);
		    $products = db()->query("SELECT id, name, categoryID FROM Products ORDER BY priority DESC");
		    $products = $products->fetchAll(PDO::FETCH_ASSOC);
		    
		    $productList = ProductService::buildTree($categories, $products);
				
				$requiredProducts = db()->prepare("SELECT requiredProductID FROM ProductRequiredProducts WHERE productID = ?");
				$requiredProducts->execute(array($id));
				$requiredProducts = $requiredProducts->fetchAll(PDO::FETCH_COLUMN);
				$product["requiredProducts"] = $requiredProducts;
	    
		    $variables= db()->query("SELECT * FROM StoreVariables");
		    $variables = $variables->fetchAll();
				
				$productVariables = db()->prepare("SELECT variableID FROM ProductVariables WHERE productID = ?");
				$productVariables->execute([$id]);
	      $product["variables"] = $productVariables->fetchAll(PDO::FETCH_COLUMN);
	    
		    $accountLinkingProviders = [];
		    if (!moduleIsDisabled('account_linking')) {
			    $accountLinkingProviders = db()->prepare("SELECT * FROM AccountLinkingProviders WHERE isEnabled = ? AND slug != ?");
			    $accountLinkingProviders->execute([1, settings('loginProvider')]);
			    $accountLinkingProviders = $accountLinkingProviders->fetchAll();
		    }
	    
		    $requiredLinkedAccounts = db()->prepare("SELECT requiredProviderID FROM ProductRequiredLinkedAccounts WHERE productID = ?");
		    $requiredLinkedAccounts->execute(array($id));
		    $requiredLinkedAccounts = $requiredLinkedAccounts->fetchAll(PDO::FETCH_COLUMN);
		    $product["requiredLinkedAccounts"] = $requiredLinkedAccounts;

        return view('store.products.edit', compact('product', 'servers', 'roles', 'variables', 'commands', 'productList', 'accountLinkingProviders'));
    }

    public function update($id)
    {
        validate([
          'name' => 'required',
          'categoryID' => 'required',
          'details' => 'required',
          'price' => 'required',
          'discountStatus' => 'required',
          'discountedPrice' => 'required_if:discountStatus,1',
          'discountDurationStatus' => 'required_if:discountStatus,1',
          'discountDuration' => 'required_if:discountDurationStatus,1',
          'durationStatus' => 'required',
          'duration' => 'required_if:durationStatus,1',
          'stockStatus' => 'required',
          'stock' => 'required_if:stockStatus,1',
          'isFeaturedProduct' => 'required',
          'minecraftStatus' => 'required',
          'minecraftTitle' => 'nullable',
          'minecraftDescription' => 'nullable',
          'minecraftItem' => 'required_if:minecraftStatus,1',
	        'minecraftItemModelID' => 'nullable',
          'giveRoleID' => 'required',
          'priority' => 'required',
          'image' => 'nullable|uploaded_file',
	        'requiredLinkedAccounts' => 'nullable|array',
	        'requiredProducts' => 'nullable|array',
	        'requireOnlyOneProduct' => 'required',
	        'disableGifting' => 'required',
	        'disableQuantity' => 'required',
          'isActive' => 'required'
        ]);
	    
		    $product = db()->prepare("SELECT * FROM Products WHERE id = ?");
		    $product->execute(array($id));
		    $product = $product->fetch();
				
				if (!$product) return view('404');

        if (input("stockStatus") == 0) {
          set_input('stock', -1);
        }
        if (input("durationStatus") == 0) {
          set_input('duration', 0);
        }
        if (input("durationStatus") == -1) {
          set_input('duration', -1);
        }
        if (input("discountStatus") == 0) {
          set_input('discountedPrice', 0);
        }
        if (input("discountDurationStatus") == 0 || input("discountStatus") == 0) {
          set_input('discountDuration', '1000-01-01 00:00:00');
        } else {
          set_input('discountDuration', date("Y-m-d H:i:s", strtotime(input("discountDuration"))));
        }

        if (input()->file('image')->size) {
            $upload = new Upload($_FILES["image"]);
            $imageID = md5(uniqid(rand(0, 9999)));
            if ($upload->uploaded) {
                $upload->allowed = array("image/*");
                $upload->file_overwrite = true;
                $upload->file_new_name_body = $imageID;
                $upload->process(__ROOT__ . "/apps/main/public/images/store/products/");
                if ($upload->processed) {
                    $updateProducts = db()->prepare("UPDATE Products SET imageID = ?, imageType = ? WHERE id = ?");
                    $updateProducts->execute(array($imageID, $upload->file_dst_name_ext, $id));
                } else {
                    return back()->flash("error", t__('An error occupied while uploading an image: %error%', ['%error%' => $upload->error]));
                }
            }
        }

        $updateProducts = db()->prepare("UPDATE Products SET name = ?, categoryID = ?, details = ?, price = ?, discountedPrice = ?, discountExpiryDate = ?, duration = ?, stock = ?, priority = ?, isFeaturedProduct = ?, minecraftStatus = ?, minecraftTitle = ?, minecraftDescription = ?, minecraftItem = ?, minecraftItemModelID = ?, giveRoleID = ?, requireOnlyOneProduct = ?, disableGifting = ?, disableQuantity= ?, isActive = ? WHERE id = ?");
        $updateProducts->execute(array(input("name"), input("categoryID"), filteredContent($_POST["details"]), input("price"), input("discountedPrice"), input("discountDuration"), input("duration"), input("stock"), input("priority"), input("isFeaturedProduct"), input("minecraftStatus"), input("minecraftTitle"), input("minecraftDescription"), input("minecraftItem"), input("minecraftItemModelID"), input("giveRoleID"), input("requireOnlyOneProduct"), input("disableGifting"), input("disableQuantity"), input("isActive"), $id));

        $commands = db()->prepare("SELECT id FROM ProductCommands WHERE productID = ? AND isActive = ?");
        $commands->execute(array($product["id"], 1));
        $commands = $commands->fetchAll(PDO::FETCH_COLUMN);

        $commandsDiff = array_diff($commands, array_filter($_POST["commandIDs"]));
        foreach ($commandsDiff as $commandID) {
          $updateProductCommands = db()->prepare("UPDATE ProductCommands SET isActive = ? WHERE id = ?");
          $updateProductCommands->execute(array(0, $commandID));
        }

        if (count(array_filter($_POST["commands"]))) {
            $insertProductCommands = db()->prepare("INSERT INTO ProductCommands (productID, serverID, command) VALUES (?, ?, ?)");
            $updateProductCommands = db()->prepare("UPDATE ProductCommands SET command = ?, serverID = ? WHERE id = ?");

            foreach ($_POST["commands"] as $key => $command) {
                $command = ltrim($_POST["commands"][$key], '/');
                $serverID = strip_tags($_POST["servers"][$key]);
                if (isset($_POST["commandIDs"][$key]) && $_POST["commandIDs"][$key] != '') {
                    $updateProductCommands->execute(array($command, $serverID, $_POST["commandIDs"][$key]));
                }
                else {
                  $insertProductCommands->execute(array($product["id"], $serverID, $command));
                }
            }
        }
	    
		    if (!moduleIsDisabled('account_linking')) {
			    $requiredLinkedAccounts = input("requiredLinkedAccounts");
			    $deleteRequiredLinkedAccounts = db()->prepare("DELETE FROM ProductRequiredLinkedAccounts WHERE productID = ?");
			    $deleteRequiredLinkedAccounts->execute(array($id));
			    if ($requiredLinkedAccounts) {
				    $insertRequiredLinkedAccounts = db()->prepare("INSERT INTO ProductRequiredLinkedAccounts (productID, requiredProviderID) VALUES (?, ?)");
				    foreach ($requiredLinkedAccounts as $requiredProviderID) {
					    $insertRequiredLinkedAccounts->execute(array($id, $requiredProviderID));
				    }
			    }
		    }
				
				$requiredProducts = input("requiredProducts");
		    $deleteRequiredProducts = db()->prepare("DELETE FROM ProductRequiredProducts WHERE productID = ?");
		    $deleteRequiredProducts->execute(array($id));
				if ($requiredProducts) {
					$insertRequiredProducts = db()->prepare("INSERT INTO ProductRequiredProducts (productID, requiredProductID) VALUES (?, ?)");
					foreach ($requiredProducts as $requiredProductsID) {
						$insertRequiredProducts->execute(array($id, $requiredProductsID));
					}
				}
	    
		    $variables = input("variables");
		    if ($variables) {
					$currentVariables = db()->prepare("SELECT variableID FROM ProductVariables WHERE productID = ?");
					$currentVariables->execute([$id]);
					$currentVariables = $currentVariables->fetchAll(PDO::FETCH_COLUMN);
			    
			    // Variable IDs to be added (selected by the user but not currently in the database)
			    $toInsert = array_diff($variables, $currentVariables);
			    
			    // Variable IDs to be deleted (existing in the database but not selected by the user)
			    $toDelete = array_diff($currentVariables, $variables);
			    
			    // Add new variable IDs
			    if (!empty($toInsert)) {
				    $insertStmt = db()->prepare("INSERT INTO ProductVariables (productID, variableID) VALUES (?, ?)");
				    foreach ($toInsert as $variableID) {
					    $insertStmt->execute([$id, $variableID]);
				    }
			    }
			    
			    // Remove unselected variable IDs
			    if (!empty($toDelete)) {
				    $deleteStmt = db()->prepare("DELETE FROM ProductVariables WHERE productID = ? AND variableID = ?");
				    foreach ($toDelete as $variableID) {
					    $deleteStmt->execute([$id, $variableID]);
				    }
			    }
		    } else {
					// If variables cleared then delete all product variables
			    $deleteProductVariables = db()->prepare("DELETE FROM ProductVariables WHERE productID = ?");
			    $deleteProductVariables->execute(array($id));
		    }

        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function order()
    {
      $_POST = json_decode(file_get_contents('php://input'),true);

      validate([
        "json" => "required"
      ], false);

      if ($_POST["json"] == "" || $_POST["json"] == '{}')
        return false;

      global $productPriority, $categoryPriority;
      $productPriority = 999;
      $categoryPriority = 999;

      $items = json_decode($_POST["json"], true);
      function treeLoop($item) {
        global $productPriority, $categoryPriority;

        if ($item["type"] == "category") {
          $updateCategory = db()->prepare("UPDATE ProductCategories SET priority = ? WHERE id = ?");
          $updateCategory->execute([$categoryPriority, $item["id"]]);

          $categoryPriority--;
        } else {
          $updateProduct = db()->prepare("UPDATE Products SET priority = ? WHERE id = ?");
          $updateProduct->execute([$productPriority, $item["id"]]);

          $productPriority--;
        }

        if (isset($item["children"])) {
          foreach ($item["children"] as $child) {
            treeLoop($child);
          }
        }
      }

      foreach ($items as $item) {
        treeLoop($item);
      }
	    
	    CacheService::updateStoreCategoryTree();

      response()->json([
        'status' => true,
        'message' => t__('Changes has been saved successfully!')
      ]);
    }

    public function destroy($id)
    {
        $deleteProduct = db()->prepare("DELETE FROM Products WHERE id = ?");
        $deleteProduct->execute(array($id));
        return back();
    }
	
		public function clone($id)
		{
			$product = db()->prepare("SELECT * FROM Products WHERE id = ?");
			$product->execute(array($id));
			$product = $product->fetch();
			
			if (!$product) return view('404');
			
			$servers = db()->query("SELECT * FROM Servers ORDER BY name ASC");
			$servers = $servers->fetchAll();
			
			$roles = db()->query("SELECT * FROM Roles ORDER BY priority DESC");
			
			$commands = db()->prepare("SELECT * FROM ProductCommands WHERE productID = ? AND isActive = ?");
			$commands->execute(array($product["id"], 1));
			$commands = $commands->fetchAll(PDO::FETCH_ASSOC);
			
			$categories = db()->query("SELECT id, name, parentID FROM ProductCategories");
			$categories = $categories->fetchAll(PDO::FETCH_ASSOC);
			$products = db()->query("SELECT id, name, categoryID FROM Products ORDER BY priority DESC");
			$products = $products->fetchAll(PDO::FETCH_ASSOC);
			
			$productList = ProductService::buildTree($categories, $products);
			
			$requiredProducts = db()->prepare("SELECT requiredProductID FROM ProductRequiredProducts WHERE productID = ?");
			$requiredProducts->execute(array($id));
			$requiredProducts = $requiredProducts->fetchAll(PDO::FETCH_COLUMN);
			$product["requiredProducts"] = $requiredProducts;
			
			$variables= db()->query("SELECT * FROM StoreVariables");
			$variables = $variables->fetchAll();
			
			$productVariables = db()->prepare("SELECT variableID FROM ProductVariables WHERE productID = ?");
			$productVariables->execute([$id]);
			$product["variables"] = $productVariables->fetchAll(PDO::FETCH_COLUMN);
			
			$accountLinkingProviders = [];
			if (!moduleIsDisabled('account_linking')) {
				$accountLinkingProviders = db()->prepare("SELECT * FROM AccountLinkingProviders WHERE isEnabled = ? AND slug != ?");
				$accountLinkingProviders->execute([1, settings('loginProvider')]);
				$accountLinkingProviders = $accountLinkingProviders->fetchAll();
			}
			
			$requiredLinkedAccounts = db()->prepare("SELECT requiredProviderID FROM ProductRequiredLinkedAccounts WHERE productID = ?");
			$requiredLinkedAccounts->execute(array($id));
			$requiredLinkedAccounts = $requiredLinkedAccounts->fetchAll(PDO::FETCH_COLUMN);
			$product["requiredLinkedAccounts"] = $requiredLinkedAccounts;
			
			return view('store.products.clone', compact('product', 'servers', 'roles', 'variables', 'commands', 'productList', 'accountLinkingProviders'));
		}
}