<?php

namespace Dashboard\Controllers\Store;

use Dashboard\Core\Controller;
use PDO;

class VariableController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_STORE');
    }

    public function index()
    {
        $variables = db()->query("SELECT * FROM StoreVariables ORDER BY id DESC");
				$variables = $variables->fetchAll();

        return view('store.variables.index', compact('variables'));
    }

    public function create()
    {
        return view('store.variables.create');
    }

    public function store()
    {
        validate([
            'identifier' => 'required',
            'name' => 'required',
            'description' => 'nullable',
            'type' => 'required',
        ]);
				
				// Check identifier with regex
        if (!preg_match('/^[a-zA-Z0-9_]+$/', input("identifier"))) {
          return back()->flash("error", t__('Identifier can only contain letters, numbers, and underscores!'));
		    }
				
				// Check if identifier already exists
        $checkIdentifier = db()->prepare("SELECT * FROM StoreVariables WHERE identifier = ?");
        $checkIdentifier->execute([input("identifier")]);
        $checkIdentifier = $checkIdentifier->fetch();
        if ($checkIdentifier) {
          return back()->flash("error", t__('Identifier already exists!'));
				}
	    
		    $insertVariable = db()->prepare("INSERT INTO StoreVariables (identifier, name, description, type) VALUES (?, ?, ?, ?)");
	      $insertVariable->execute([input("identifier"), input("name"), input("description"), input("type")]);
				$variableID = db()->lastInsertId();
				
				if (input("type") == "dropdown" && count(array_filter($_POST["names"]))) {
					$insertVariableDropdown = db()->prepare("INSERT INTO StoreVariableDropdownOptions (variableID, name, value, price) VALUES (?, ?, ?, ?)");
					foreach ($_POST["names"] as $key => $name) {
						$name = $_POST["names"][$key];
						$value = $_POST["values"][$key];
						$price = $_POST["prices"][$key];
						$insertVariableDropdown->execute(array($variableID, $name, $value, $price));
					}
				}
				
        return back()->flash("success", t__('Variable has been added successfully!'));
    }

    public function edit($id)
    {
		    $variable = db()->prepare("SELECT * FROM StoreVariables WHERE id = ?");
		    $variable->execute(array($id));
		    $variable = $variable->fetch();

        if (!$variable) return view('404');
	    
	      $variable['dropdown'] = [];
				if ($variable['type'] == "dropdown") {
					$dropdown = db()->prepare("SELECT * FROM StoreVariableDropdownOptions WHERE variableID = ?");
					$dropdown->execute(array($id));
					$variable['dropdown'] = $dropdown->fetchAll(PDO::FETCH_ASSOC);
				}
				
        return view('store.variables.edit', compact('variable'));
    }

    public function update($id)
    {
		    validate([
			    'identifier' => 'required',
			    'name' => 'required',
			    'description' => 'nullable',
			    'type' => 'required',
		    ]);
	    
		    if (!preg_match('/^[a-zA-Z0-9_]+$/', input("identifier"))) {
					return back()->flash("error", t__('Identifier can only contain letters, numbers, and underscores!'));
				}
				
				$checkIdentifier = db()->prepare("SELECT * FROM StoreVariables WHERE identifier = ? AND id != ?");
				$checkIdentifier->execute([input("identifier"), $id]);
				$checkIdentifier = $checkIdentifier->fetch();
				if ($checkIdentifier) {
					return back()->flash("error", t__('Identifier already exists!'));
				}
	    
	      $updateVariable = db()->prepare("UPDATE StoreVariables SET identifier = ?, name = ?, description = ?, type = ? WHERE id = ?");
        $updateVariable->execute([input("identifier"), input("name"), input("description"), input("type"), $id]);
	    
				$deleteDropdownOptions = db()->prepare("DELETE FROM StoreVariableDropdownOptions WHERE variableID = ?");
				$deleteDropdownOptions->execute(array($id));
		    if (input("type") == "dropdown" && count(array_filter($_POST["names"]))) {
			    $insertVariableDropdown = db()->prepare("INSERT INTO StoreVariableDropdownOptions (variableID, name, value, price) VALUES (?, ?, ?, ?)");
			    foreach ($_POST["names"] as $key => $name) {
				    $name = $_POST["names"][$key];
				    $value = $_POST["values"][$key];
				    $price = $_POST["prices"][$key];
				    $insertVariableDropdown->execute(array($id, $name, $value, $price));
			    }
		    }
				
        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $deleteVariable = db()->prepare("DELETE FROM StoreVariables WHERE id = ?");
	      $deleteVariable->execute(array($id));
				
				$deleteProductVariables = db()->prepare("DELETE FROM ProductVariables WHERE variableID = ?");
				$deleteProductVariables->execute(array($id));
				
				// Delete dropdown options
	      $deleteDropdownOptions = db()->prepare("DELETE FROM StoreVariableDropdownOptions WHERE variableID = ?");
				$deleteDropdownOptions->execute(array($id));
				
				// Delete order product variable values
	      $deleteOrderProductVariableValues = db()->prepare("DELETE FROM OrderProductVariableValues WHERE variableID = ?");
	      $deleteOrderProductVariableValues->execute(array($id));
				
        return back();
    }
}