<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;

class SuggestionCategoryController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_SUGGESTIONS');
    }

    public function index()
    {
        $categories = db()->query("SELECT * FROM SuggestionCategories ORDER BY id DESC");
        $categories = $categories->fetchAll();

        return view('suggestions.categories.index', compact('categories'));
    }

    public function create()
    {
        return view('suggestions.categories.create');
    }

    public function store()
    {
        validate([
            'name' => 'required',
        ]);
	    
		    $slug = slugify(input("name"));

        $insertSuggestionCategories = db()->prepare("INSERT INTO SuggestionCategories (name, slug) VALUES (?, ?)");
        $insertSuggestionCategories->execute(array(input("name"), $slug));
        return back()->flash("success", t__('Category has been added successfully!'));
    }

    public function edit($id)
    {
        $category = db()->prepare("SELECT * FROM SuggestionCategories WHERE id = ?");
        $category->execute(array($id));
        $category = $category->fetch();

        if (!$category) return view('404');

        return view('suggestions.categories.edit', compact('category'));
    }

    public function update($id)
    {
        validate([
            'name' => 'required',
        ]);
	    
		    $slug = slugify(input("name"));

        $updateSuggestionCategories = db()->prepare("UPDATE SuggestionCategories SET name = ?, slug = ? WHERE id = ?");
        $updateSuggestionCategories->execute(array(input("name"), $slug, $id));
        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $deleteSuggestionCategory = db()->prepare("DELETE FROM SuggestionCategories WHERE id = ?");
        $deleteSuggestionCategory->execute(array($id));
        return back();
    }
}