<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;

class SupportCategoryController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_SUPPORT') && abort_perm('MANAGE_SUPPORT_TICKETS');
    }

    public function index()
    {
        $categories = db()->query("SELECT * FROM SupportCategories ORDER BY id DESC");
        $categories = $categories->fetchAll();
        return view('supports.categories.index', compact('categories'));
    }

    public function create()
    {
        return view('supports.categories.create');
    }

    public function store()
    {
        validate([
            'name' => 'required',
        ]);

        $insertSupportCategories = db()->prepare("INSERT INTO SupportCategories (name) VALUES (?)");
        $insertSupportCategories->execute(array(input("name")));

        $categoryID = db()->lastInsertId();
        foreach ($_POST["supportField"] as $key => $value) {
            if ($_POST["supportField"][$key] == '')
                continue;
            $_POST["supportField"][$key] = strip_tags($_POST["supportField"][$key]);
            $_POST["supportFieldType"][$key] = strip_tags($_POST["supportFieldType"][$key]);
            $_POST["supportFieldVariables"][$key] = ($_POST["supportFieldVariables"][$key] != null) ? strip_tags($_POST["supportFieldVariables"][$key]) : '-';
            $insertCustomSupportFields = db()->prepare("INSERT INTO CustomSupportFields (categoryID, field, type, variables) VALUES (?, ?, ?, ?)");
            $insertCustomSupportFields->execute(array($categoryID, $_POST["supportField"][$key], $_POST["supportFieldType"][$key], $_POST["supportFieldVariables"][$key]));
        }

        return back()->flash("success", t__('Category has been added successfully!'));
    }

    public function edit($id)
    {
        $supportCategory = db()->prepare("SELECT * FROM SupportCategories WHERE id = ?");
        $supportCategory->execute(array($id));
      $supportCategory = $supportCategory->fetch();

      if (!$supportCategory) return view('404');

        return view('supports.categories.edit', compact('supportCategory'));
    }

    public function update($id)
    {
        validate([
            'name' => 'required',
        ]);

        $supportCategory = db()->prepare("SELECT * FROM SupportCategories WHERE id = ?");
        $supportCategory->execute(array($id));
        $readSupportCategory = $supportCategory->fetch();

        $updateSupportCategories = db()->prepare("UPDATE SupportCategories SET name = ? WHERE id = ?");
        $updateSupportCategories->execute(array(input("name"), $id));

        $categoryID = $readSupportCategory["id"];
        $disableOldQuestions = db()->prepare("UPDATE CustomSupportFields SET isEnabled = ? WHERE categoryID = ?");
        $disableOldQuestions->execute(array(0, $categoryID));
        foreach ($_POST["supportField"] as $key => $value) {
            if ($_POST["supportField"][$key] == '')
                continue;
            $_POST["supportField"][$key] = strip_tags($_POST["supportField"][$key]);
            $_POST["supportFieldType"][$key] = strip_tags($_POST["supportFieldType"][$key]);
            $_POST["supportFieldVariables"][$key] = ($_POST["supportFieldVariables"][$key] != null) ? strip_tags($_POST["supportFieldVariables"][$key]) : '-';
            $insertsupportFields = db()->prepare("INSERT INTO CustomSupportFields (categoryID, field, type, variables) VALUES (?, ?, ?, ?)");
            $insertsupportFields->execute(array($categoryID, $_POST["supportField"][$key], $_POST["supportFieldType"][$key], $_POST["supportFieldVariables"][$key]));
        }
        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $deleteSupportCategory = db()->prepare("DELETE FROM SupportCategories WHERE id = ?");
        $deleteSupportCategory->execute(array($id));
        return back();
    }
}