<?php

namespace Dashboard\Controllers\TebexStore;

use Curl\Curl;
use Dashboard\Core\Controller;

class SettingController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_SETTINGS');
    }

    public function index()
    {
        return view('tebex-store.settings.index');
    }

    public function update()
    {
        validate([
          'publicKey' => 'required',
          'secretKey' => 'required',
        ]);

        updateModuleSettings('tebex_store', [
          'publicKey' => input('publicKey'),
          'secretKey' => input('secretKey'),
        ]);
				
        createLog("TEBEX_STORE_SETTINGS_UPDATED");
				
        return back()->flash("success", t__('Changes has been saved successfully!'));

    }
}