<?php

namespace Dashboard\Controllers;

use Dashboard\Core\Controller;
use PDO;

class UrlRedirectController extends Controller
{
    public function __construct()
    {
        abort_perm('MANAGE_SETTINGS');
    }

    public function index()
    {
        $redirects = db()->query("SELECT * FROM UrlRedirects ORDER BY id DESC");
		    $redirects = $redirects->fetchAll(PDO::FETCH_ASSOC);

        return view('redirects.index', compact('redirects'));
    }

    public function create()
    {
        return view('redirects.create');
    }

    public function store()
    {
        validate([
            'from' => 'required',
            'to' => 'required'
        ]);

        $insertRedirect = db()->prepare("INSERT INTO UrlRedirects (`from`, `to`, `creationDate`) VALUES (?, ?, ?)");
        $insertRedirect->execute(array(input("from"), input("to"), datetime()));
        return back()->flash("success", t__('URL Redirect has been added successfully!'));
    }

    public function edit($id)
    {
        $redirect = db()->prepare("SELECT * FROM UrlRedirects WHERE id = ?");
		    $redirect->execute(array($id));
		    $redirect = $redirect->fetch();

        if (!$redirect) return view('404');

        return view('redirects.edit', compact('redirect'));
    }

    public function update($id)
    {
        validate([
            'from' => 'required',
            'to' => 'required',
        ]);

        $updateRedirect = db()->prepare("UPDATE UrlRedirects SET `from` = ?, `to` = ? WHERE `id` = ?");
        $updateRedirect->execute(array(input("from"), input("to"), $id));
        return back()->flash("success", t__('Changes has been saved successfully!'));
    }

    public function destroy($id)
    {
        $deleteRedirect = db()->prepare("DELETE FROM UrlRedirects WHERE id = ?");
		    $deleteRedirect->execute(array($id));
			
        return back();
    }
}