<?php
	
	namespace Dashboard\Services;
	
	use PDO;
	
	class CacheService
	{
		public static function updateStoreCategoryTree()
		{
			$categories = db()->query("SELECT id, name, parentID FROM ProductCategories");
			$categories = $categories->fetchAll(PDO::FETCH_ASSOC);
			$categoryList = CategoryService::buildTree($categories);
			if (settings('cache:category_tree') !== null) {
				updateSetting('cache:category_tree', json_encode($categoryList));
			} else {
				$insert = db()->prepare("INSERT INTO Settings (name, value) VALUES (?, ?)");
				$insert->execute(['cache:category_tree', json_encode($categoryList)]);
			}
		}
	}