<?php
	namespace Dashboard\Services;
	
	use PHPMailer\PHPMailer\Exception;
	use PHPMailer\PHPMailer\PHPMailer;
	
	class EmailService
	{
		/**
		 * @throws Exception
		 */
		public static function send($to, $title, $content)
		{
			$mail = new PHPMailer(true);
			$mail->IsSMTP();
			$mail->SMTPAuth = true;
			$mail->Host = settings('smtpServer');
			$mail->Port = settings('smtpPort');
			$mail->SMTPSecure = ((settings('smtpSecure') == 1) ? PHPMailer::ENCRYPTION_SMTPS : ((settings('smtpSecure') == 2) ? PHPMailer::ENCRYPTION_STARTTLS : PHPMailer::ENCRYPTION_SMTPS));
			$mail->Username = settings('smtpUsername');
			$mail->Password = settings('smtpPassword');
			$mail->SetFrom(settings('smtpSenderEmail'), settings('serverName'));
			$mail->AddAddress($to);
			$mail->isHTML(true);
			$mail->CharSet = 'UTF-8';
			$mail->Subject = $title;
			$mail->Body = $content;
			$mail->send();
		}
	}