<?php
namespace Dashboard\Services;

class ProductService
{
  public static function buildTree($categories, $products, $parent_id = 0): array
  {
    $tree = [];

    foreach ($categories as $category) {
      if ($category['parentID'] == $parent_id) {
        $categoryNode = $category;

        $categoryNode["subcategories"] = self::buildTree($categories, $products, $category['id']);
        $categoryNode["products"] = array();

        foreach ($products as &$product) {
          if (isset($product["price"])) {
            if (
              $product["discountedPrice"] > 0 &&
              (
                $product["discountExpiryDate"] > date("Y-m-d H:i:s") ||
                $product["discountExpiryDate"] == '1000-01-01 00:00:00'
              )
            ) {
              $product["price"] = $product["discountedPrice"];
            }
          }
          if ($product['categoryID'] == $category['id']) {
            $categoryNode['products'][] = $product;
          }
        }

        $tree[] = $categoryNode;
      }
    }

    return $tree;
  }
}