<?php
namespace Dashboard\Services;

use Fuse\Fuse;
use PDO;

class SearchService
{
	private $array = [];
	private $processed = [];
	private const MAX_RESULTS = 10;
	
	// constructor
	public function __construct()
	{
		$this->array = [
			'user-management' => [
				'title' => t__('User Management'),
				'icon' => 'profile',
				'permission' => ['MANAGE_ACCOUNTS', 'MANAGE_ROLES', 'MANAGE_BANS'],
				'items' => [
					[
						'title' => t__('User Management'),
						'items' => [
							[
								'title' => t__('Users'),
								'route' => 'dashboard.accounts.index',
								'category' => 'user-management.users',
								'icon' => 'user',
								'permission' => ['MANAGE_ACCOUNTS'],
								'items' => [
									[
										'title' => t__('Create Account'),
										'route' => 'dashboard.accounts.create',
										'icon' => 'user',
										'permission' => ['MANAGE_ACCOUNTS'],
									]
								]
							],
							[
								'title' => t__('Roles'),
								'route' => 'dashboard.roles.index',
								'category' => 'user-management.roles',
								'icon' => 'shield-security',
								'permission' => ['MANAGE_ROLES'],
								'items' => [
									[
										'title' => t__('Create Role'),
										'route' => 'dashboard.roles.create',
										'icon' => 'shield-security',
										'permission' => ['MANAGE_ROLES'],
									]
								]
							],
							[
								'title' => t__('Staff'),
								'route' => 'dashboard.accounts.staff',
								'category' => 'user-management.staff',
								'icon' => 'user-tick',
								'permission' => ['MANAGE_ACCOUNTS'],
							],
							[
								'title' => t__('Bans'),
								'route' => 'dashboard.bans.index',
								'category' => 'user-management.bans',
								'icon' => 'forbidden',
								'permission' => ['MANAGE_BANS'],
							],
							[
								'title' => t__('Custom Fields'),
								'route' => 'dashboard.custom-fields.index',
								'category' => 'user-management.custom-fields',
								'icon' => 'add-square',
								'permission' => ['MANAGE_ACCOUNTS'],
								'items' => [
									[
										'title' => t__('Create Custom Field'),
										'route' => 'dashboard.custom-fields.create',
										'icon' => 'add-square',
										'permission' => ['MANAGE_ACCOUNTS'],
									]
								]
							]
						]
					],
					[
						'title' => t__('Actions'),
						'items' => [
							[
								'title' => t__('Ban User'),
								'route' => 'dashboard.bans.create',
								'category' => 'user-management.actions.ban-user',
								'icon' => 'forbidden',
								'permission' => ['MANAGE_BANS'],
							],
							[
								'title' => t__('Send Credits'),
								'route' => 'dashboard.store.credit.send.index',
								'category' => 'user-management.actions.send-credits',
								'icon' => 'money-recive',
								'module' => ['credit'],
								'permission' => ['MANAGE_ACCOUNTS'],
							],
							[
								'title' => t__('Send Chest Item'),
								'route' => 'dashboard.store.chest.send.index',
								'category' => 'user-management.actions.send-chest-item',
								'icon' => 'strongbox',
								'module' => ['chest'],
								'permission' => ['MANAGE_ACCOUNTS'],
							]
						]
					]
				]
			],
			'store' => [
				'title' => t__('Store'),
				'icon' => 'shopping-cart',
				'module' => ['store'],
				'show' => moduleIsDisabled('tebex_store'),
				'permission' => ['MANAGE_STORE', 'MANAGE_SERVERS', 'MANAGE_GIFTS', 'MANAGE_GAMING_NIGHT', 'MANAGE_COMMUNITY_GOALS'],
				'items' => [
					[
						'title' => t__('Store'),
						'items' => [
							[
								'title' => t__('Products'),
								'route' => 'dashboard.store.products.index',
								'icon' => 'shopping-cart',
								'permission' => ['MANAGE_STORE'],
								'items' => [
									[
										'title' => t__('Create Product'),
										'route' => 'dashboard.store.products.create',
										'icon' => 'shopping-cart',
										'permission' => ['MANAGE_STORE'],
									]
								]
							],
							[
								'title' => t__('Categories'),
								'route' => 'dashboard.store.categories.index',
								'category' => 'store.categories',
								'icon' => 'category-2',
								'permission' => ['MANAGE_STORE'],
								'items' => [
									[
										'title' => t__('Create Category'),
										'route' => 'dashboard.store.categories.create',
										'icon' => 'category-2',
										'permission' => ['MANAGE_STORE'],
									]
								]
							],
							[
								'title' => t__('Game Servers'),
								'route' => 'dashboard.servers.index',
								'category' => 'store.servers',
								'icon' => 'code-1',
								'permission' => ['MANAGE_SERVERS'],
								'items' => [
									[
										'title' => t__('Create Server'),
										'route' => 'dashboard.servers.create',
										'icon' => 'code-1',
										'permission' => ['MANAGE_SERVERS'],
									]
								]
							],
							[
								'title' => t__('Coupons'),
								'route' => 'dashboard.store.coupons.index',
								'category' => 'store.coupons',
								'icon' => 'ticket-discount',
								'permission' => ['MANAGE_STORE'],
								'items' => [
									[
										'title' => t__('Create Coupon'),
										'route' => 'dashboard.store.coupons.create',
										'icon' => 'ticket-discount',
										'permission' => ['MANAGE_STORE'],
									]
								]
							],
							[
								'title' => t__('Creator Codes'),
								'route' => 'dashboard.store.creator-codes.index',
								'category' => 'store.creator-codes',
								'icon' => 'ticket-star',
								'permission' => ['MANAGE_STORE'],
								'items' => [
									[
										'title' => t__('Create Creator Code'),
										'route' => 'dashboard.store.creator-codes.create',
										'icon' => 'ticket-star',
										'permission' => ['MANAGE_STORE'],
									]
								]
							],
							[
								'title' => t__('Gifts'),
								'route' => 'dashboard.gifts.index',
								'category' => 'store.gifts',
								'icon' => 'gift',
								'permission' => ['MANAGE_GIFTS'],
								'items' => [
									[
										'title' => t__('Create Gift'),
										'route' => 'dashboard.store.gifts.create',
										'icon' => 'gift',
										'permission' => ['MANAGE_STORE'],
									]
								]
							],
							[
								'title' => t__('Orders'),
								'route' => 'dashboard.store.orders.index',
								'category' => 'store.orders',
								'icon' => 'bag',
								'permission' => ['MANAGE_STORE'],
								'items' => [
									[
										'title' => t__('Create Order'),
										'route' => 'dashboard.store.orders.create',
										'icon' => 'bag',
									],
								]
							],
							[
								'title' => t__('Payments'),
								'route' => 'dashboard.store.payments.index',
								'category' => 'store.payments',
								'icon' => 'card',
								'permission' => ['MANAGE_STORE'],
							],
							[
								'title' => t__('VIP Tables'),
								'route' => 'dashboard.vip-tables.index',
								'category' => 'store.vip-tables',
								'icon' => 'grid-7',
								'permission' => ['MANAGE_STORE'],
								'items' => [
									[
										'title' => t__('Create VIP Table'),
										'route' => 'dashboard.store.vip-tables.create',
										'icon' => 'grid-7',
										'permission' => ['MANAGE_STORE'],
									]
								]
							],
							[
								'title' => t__('Credit Packages'),
								'route' => 'dashboard.store.credit-packages.index',
								'category' => 'store.credit-packages',
								'icon' => 'coin-1',
								'permission' => ['MANAGE_STORE'],
								'show' => moduleSettings('credit', 'creditPackageStatus') == 1,
								'items' => [
									[
										'title' => t__('Create Credit Package'),
										'route' => 'dashboard.store.credit-packages.create',
										'icon' => 'coin-1',
										'permission' => ['MANAGE_STORE'],
									]
								]
							],
							[
								'title' => t__('Gaming Night'),
								'route' => 'dashboard.gaming-night.index',
								'category' => 'store.gaming-night',
								'icon' => 'moon',
								'permission' => ['MANAGE_GAMING_NIGHT'],
							],
							[
								'title' => t__('Bulk Discount'),
								'route' => 'dashboard.store.bulk-discount.index',
								'category' => 'store.bulk-discount',
								'icon' => 'percentage-square',
								'permission' => ['MANAGE_STORE'],
							],
							[
								'title' => t__('Community Goals'),
								'route' => 'dashboard.store.community-goals.index',
								'category' => 'store.community-goal',
								'icon' => 'shopping-bag',
								'permission' => ['MANAGE_COMMUNITY_GOALS'],
							],
							[
								'title' => t__('Variables'),
								'route' => 'dashboard.store.variables.index',
								'category' => 'store.variables',
								'icon' => 'add-square',
								'permission' => ['MANAGE_STORE'],
								'items' => [
									[
										'title' => t__('Create Variable'),
										'route' => 'dashboard.store.variables.create',
										'icon' => 'add-square',
									]
								],
							],
							[
								'title' => t__('Settings'),
								'route' => 'dashboard.settings.store.index',
								'category' => 'settings.store',
								'icon' => 'setting-2',
							]
						]
					]
				]
			],
			'tebex-store' => [
				'title' => t__('Tebex Store'),
				'svg' => '<svg fill="none" stroke="white" style="width: 20px; position: relative; stroke-width: 4px;" viewBox="16 0 75 75" xmlns="http://www.w3.org/2000/svg"><path d="M55.8364 19.1468C58.6805 14.4276 63.8309 13.0604 63.8309 13.0604C63.8309 13.0604 54.0012 10.4463 54.0012 0C54.0012 10.4463 44.1658 13.0604 44.1658 13.0604C44.1658 13.0604 49.3181 14.4276 52.1641 19.1468H38.7266V37.239L41.7815 31.6362H47.8894V62.8606L60.1072 75.35V37.1186C56.9915 35.6504 52.5155 31.9178 50.9121 29.0707C53.6497 29.9155 57.3221 31.0264 60.1813 31.6381H69.272V19.1468H55.8364Z"></path></svg>',
				'module' => ['tebex_store'],
				'permission' => ['MANAGE_STORE'],
				'items' => [
					[
						'title' => t__('Tebex Store'),
						'items' => [
							[
								'title' => t__('Dashboard'),
								'url' => 'https://creator.tebex.io/dashboard',
								'target' => '_blank',
								'icon' => 'category',
							],
							[
								'title' => t__('Statistics'),
								'url' => 'https://creator.tebex.io/statistics',
								'target' => '_blank',
								'icon' => 'diagram',
							],
							[
								'title' => t__('Payments'),
								'url' => 'https://creator.tebex.io/payments',
								'target' => '_blank',
								'icon' => 'card',
							],
							[
								'title' => t__('Packages'),
								'url' => 'https://creator.tebex.io/packages',
								'target' => '_blank',
								'icon' => 'archive-1',
							],
							[
								'title' => t__('Coupons'),
								'url' => 'https://creator.tebex.io/coupons',
								'target' => '_blank',
								'icon' => 'ticket-discount',
							],
							[
								'title' => t__('Sales'),
								'url' => 'https://creator.tebex.io/sales',
								'target' => '_blank',
								'icon' => 'percentage-square',
							],
							[
								'title' => t__('Creator Codes'),
								'url' => 'https://creator.tebex.io/creator-codes',
								'target' => '_blank',
								'icon' => 'barcode',
							],
							[
								'title' => t__('Gift Cards'),
								'url' => 'https://creator.tebex.io/giftcards',
								'target' => '_blank',
								'icon' => 'gift',
							],
							[
								'title' => t__('VIP Tables'),
								'route' => 'dashboard.vip-tables.index',
								'category' => 'tebex-store.vip-tables',
								'icon' => 'grid-7',
							],
							[
								'title' => t__('Settings'),
								'route' => 'dashboard.tebex-store.settings.index',
								'category' => 'tebex-store.settings',
								'icon' => 'setting-2',
							]
						]
					]
				]
			],
			'support-help' => [
				'title' => t__('Support & Help'),
				'icon' => 'lifebuoy',
				'module' => ['support', 'help'],
				'permission' => ['MANAGE_SUPPORT', 'MANAGE_SUPPORT_TICKETS', 'MANAGE_HELP'],
				'items' => [
					[
						'title' => t__('Support'),
						'module' => ['support'],
						'permission' => ['MANAGE_SUPPORT', 'MANAGE_SUPPORT_TICKETS'],
						'items' => [
							[
								'title' => t__('Tickets'),
								'route' => 'dashboard.support.tickets.index',
								'category' => 'support-help.support.tickets',
								'icon' => 'lifebuoy',
								'permission' => ['MANAGE_SUPPORT', 'MANAGE_SUPPORT_TICKETS'],
							],
							[
								'title' => t__('Categories'),
								'route' => 'dashboard.support.categories.index',
								'icon' => 'category-2',
								'category' => 'support-help.support.categories',
								'permission' => ['MANAGE_SUPPORT'],
								'items' => [
									[
										'title' => t__('Create Category'),
										'route' => 'dashboard.support.categories.create',
										'icon' => 'category-2',
										'permission' => ['MANAGE_SUPPORT'],
									]
								]
							],
							[
								'title' => t__('Quick Answers'),
								'route' => 'dashboard.support.quick-answers.index',
								'icon' => 'message-text',
								'category' => 'support-help.support.quick-answers',
								'permission' => ['MANAGE_SUPPORT'],
								'items' => [
									[
										'title' => t__('Create Quick Answer'),
										'route' => 'dashboard.support.quick-answers.create',
										'icon' => 'message-text',
										'permission' => ['MANAGE_SUPPORT'],
									]
								]
							],
							[
								'title' => t__('Settings'),
								'route' => 'dashboard.settings.support.index',
								'category' => 'settings.support',
								'icon' => 'setting-2',
							]
						]
					],
					[
						'title' => t__('Help Center'),
						'module' => ['help'],
						'permission' => ['MANAGE_HELP_CENTER'],
						'items' => [
							[
								'title' => t__('Articles'),
								'route' => 'dashboard.help.articles.index',
								'category' => 'support-help.help.articles',
								'icon' => 'edit',
								'items' => [
									[
										'title' => t__('Create Article'),
										'route' => 'dashboard.help.articles.create',
										'icon' => 'edit',
										'permission' => ['MANAGE_HELP_CENTER'],
									]
								]
							],
							[
								'title' => t__('Topics'),
								'route' => 'dashboard.help.topics.index',
								'category' => 'support-help.help.topics',
								'icon' => 'category-2',
								'items' => [
									[
										'title' => t__('Create Topic'),
										'route' => 'dashboard.help.topics.create',
										'icon' => 'category-2',
										'permission' => ['MANAGE_HELP_CENTER'],
									]
								]
							]
						]
					]
				]
			],
			'content-management' => [
				'title' => t__('Content Management'),
				'icon' => 'edit',
				'module' => ['news', 'forum', 'page'],
				'permission' => ['MANAGE_BLOG', 'MANAGE_FORUM', 'MANAGE_PAGES'],
				'items' => [
					[
						'title' => t__('Blog'),
						'module' => ['news'],
						'permission' => ['MANAGE_BLOG'],
						'items' => [
							[
								'title' => t__('Posts'),
								'route' => 'dashboard.blog.posts.index',
								'category' => 'content-management.blog.posts',
								'icon' => 'edit',
								'items' => [
									[
										'title' => t__('Create Post'),
										'route' => 'dashboard.blog.posts.create',
										'icon' => 'edit',
										'permission' => ['MANAGE_BLOG'],
									]
								]
							],
							[
								'title' => t__('Categories'),
								'route' => 'dashboard.blog.categories.index',
								'category' => 'content-management.blog.categories',
								'icon' => 'category-2',
								'items' => [
									[
										'title' => t__('Create Category'),
										'route' => 'dashboard.blog.categories.create',
										'icon' => 'category-2',
										'permission' => ['MANAGE_BLOG'],
									]
								]
							],
							[
								'title' => t__('Comments'),
								'route' => 'dashboard.blog.comments.index',
								'category' => 'content-management.blog.comments',
								'icon' => 'message'
							]
						]
					],
					[
						'title' => t__('Forum'),
						'module' => ['forum'],
						'permission' => ['MANAGE_FORUM'],
						'items' => [
							[
								'title' => t__('Threads'),
								'route' => 'dashboard.forum.threads.index',
								'category' => 'content-management.forum.threads',
								'icon' => 'message-notif'
							],
							[
								'title' => t__('Categories'),
								'route' => 'dashboard.forum.categories.index',
								'category' => 'content-management.forum.categories',
								'icon' => 'category-2',
								'items' => [
									[
										'title' => t__('Create Category'),
										'route' => 'dashboard.forum.categories.create',
										'icon' => 'category-2',
										'permission' => ['MANAGE_FORUM'],
									]
								]
							]
						]
					],
					[
						'title' => t__('Changelog'),
						'route' => 'dashboard.changelog.index',
						'category' => 'content-management.changelog',
						'icon' => 'clipboard-tick',
						'module' => ['changelog'],
						'permission' => ['MANAGE_CHANGELOG'],
						'items' => [
							[
								'title' => t__('Create Changelog'),
								'route' => 'dashboard.changelog.create',
								'icon' => 'clipboard-tick',
							],
							[
								'title' => t__('Tags'),
								'route' => 'dashboard.changelog.tags.index',
								'category' => 'content-management.changelog.tags',
								'icon' => 'tag',
								'items' => [
									[
										'title' => t__('Create Tag'),
										'route' => 'dashboard.changelog.tags.create',
										'icon' => 'tag',
									],
								]
							],
						]
					],
					[
						'title' => t__('Other'),
						'module' => ['page'],
						'permission' => ['MANAGE_PAGES'],
						'items' => [
							[
								'title' => t__('Pages'),
								'route' => 'dashboard.pages.index',
								'category' => 'content-management.other.pages',
								'icon' => 'element-1',
								'module' => ['page'],
								'permission' => ['MANAGE_PAGES'],
								'items' => [
									[
										'title' => t__('Create Page'),
										'route' => 'dashboard.pages.create',
										'icon' => 'element-1',
										'permission' => ['MANAGE_PAGES'],
									]
								]
							],
						]
					]
				]
			],
			'forms' => [
				'title' => t__('Forms'),
				'icon' => 'document-text',
				'module' => ['application', 'form'],
				'permission' => ['MANAGE_APPLICATIONS', 'MANAGE_CUSTOM_FORMS'],
				'items' => [
					[
						'title' => t__('Applications'),
						'module' => ['application'],
						'permission' => ['MANAGE_APPLICATIONS'],
						'items' => [
							[
								'title' => t__('Application Forms'),
								'route' => 'dashboard.applications.forms.index',
								'category' => 'forms.applications.forms',
								'icon' => 'document-text',
								'items' => [
									[
										'title' => t__('Create Application Form'),
										'route' => 'dashboard.forms.applications.create',
										'icon' => 'document-text',
										'permission' => ['MANAGE_APPLICATIONS'],
									]
								]
							],
							[
								'title' => t__('Applications'),
								'route' => 'dashboard.applications.index',
								'category' => 'forms.applications',
								'icon' => 'direct-inbox'
							]
						]
					],
					[
						'title' => t__('Custom Forms'),
						'module' => ['form'],
						'permission' => ['MANAGE_CUSTOM_FORMS'],
						'items' => [
							[
								'title' => t__('Custom Forms'),
								'route' => 'dashboard.forms.index',
								'category' => 'forms.custom-forms.forms',
								'icon' => 'document-text',
								'items' => [
									[
										'title' => t__('Create Custom Form'),
										'route' => 'dashboard.forms.create',
										'icon' => 'document-text',
										'permission' => ['MANAGE_CUSTOM_FORMS'],
									]
								]
							],
							[
								'title' => t__('Submissions'),
								'route' => 'dashboard.forms.answers.index',
								'category' => 'forms.custom-forms.submissions',
								'icon' => 'direct-inbox'
							]
						]
					]
				]
			],
			'appearance' => [
				'title' => t__('Appearance'),
				'icon' => 'brush',
				'permission' => ['MANAGE_THEME'],
				'items' => [
					[
						'title' => t__('Appearance'),
						'items' => [
							[
								'title' => t__('Themes'),
								'route' => 'dashboard.appearance.themes.index',
								'category' => 'appearance.themes',
								'icon' => 'brush'
							],
							[
								'title' => t__('Theme Settings'),
								'route' => 'dashboard.appearance.themes.settings.index',
								'category' => 'appearance.themes.settings',
								'icon' => 'setting-4'
							],
							[
								'title' => t__('Theme Editor'),
								'route' => 'dashboard.appearance.editor.index',
								'category' => 'appearance.editor',
								'icon' => 'document-code',
								'target' => '_blank'
							],
							[
								'title' => t__('Header Menu'),
								'route' => 'dashboard.appearance.header.index',
								'category' => 'appearance.header',
								'icon' => 'menu'
							],
							[
								'title' => t__('Custom CSS'),
								'route' => 'dashboard.appearance.css.index',
								'category' => 'appearance.css',
								'icon' => 'brush-2'
							]
						]
					]
				]
			],
			'logs' => [
				'title' => t__('Logs'),
				'icon' => 'history',
				'module' => ['gift', 'store', 'chest', 'credit', 'lottery', 'bazaar'],
				'permission' => ['MANAGE_LOGS', 'MANAGE_STORE', 'MANAGE_LOTTERY', 'MANAGE_BAZAAR', 'MANAGE_GIFTS'],
				'items' => [
					[
						'title' => t__('Logs'),
						'items' => [
							[
								'title' => t__('Dashboard Logs'),
								'route' => 'dashboard.logs.index',
								'category' => 'logs.dashboard',
								'icon' => 'dashboard',
								'permission' => ['MANAGE_LOGS'],
							],
							[
								'title' => t__('Gift Logs'),
								'route' => 'dashboard.gifts.logs.index',
								'category' => 'logs.gift',
								'icon' => 'gift',
								'module' => ['gift'],
								'permission' => ['MANAGE_LOGS', 'MANAGE_GIFTS'],
							],
							[
								'title' => t__('Chest Logs'),
								'route' => 'dashboard.store.chest-logs.index',
								'category' => 'logs.chest',
								'icon' => 'strongbox',
								'module' => ['chest'],
								'permission' => ['MANAGE_LOGS', 'MANAGE_STORE'],
							],
							[
								'title' => t__('Coupon Logs'),
								'route' => 'dashboard.store.coupon-logs.index',
								'category' => 'logs.coupon',
								'icon' => 'ticket-discount',
								'module' => ['store'],
								'permission' => ['MANAGE_LOGS', 'MANAGE_STORE'],
							],
							[
								'title' => t__('Creator Code Logs'),
								'route' => 'dashboard.store.creator-code-logs.index',
								'category' => 'logs.creator-code',
								'icon' => 'ticket-star',
								'module' => ['store'],
								'permission' => ['MANAGE_LOGS', 'MANAGE_STORE'],
							],
							[
								'title' => t__('Credit Purchase Logs'),
								'route' => 'dashboard.store.credit-purchase-logs.index',
								'category' => 'logs.credit-purchase',
								'icon' => 'money-recive',
								'module' => ['credit'],
								'permission' => ['MANAGE_LOGS', 'MANAGE_STORE'],
							],
							[
								'title' => t__('Credit Usage Logs'),
								'route' => 'dashboard.store.credit-usage-logs.index',
								'category' => 'logs.credit-usage',
								'icon' => 'money-send',
								'module' => ['credit'],
								'permission' => ['MANAGE_LOGS', 'MANAGE_STORE'],
							],
							[
								'title' => t__('Fortune Wheel Logs'),
								'route' => 'dashboard.lotteries.logs.index',
								'category' => 'logs.lottery',
								'icon' => 'graph',
								'module' => ['lottery'],
								'permission' => ['MANAGE_LOGS', 'MANAGE_LOTTERY'],
							],
							[
								'title' => t__('Bazaar Logs'),
								'route' => 'dashboard.bazaar.logs.index',
								'category' => 'logs.bazaar',
								'icon' => 'shop',
								'module' => ['bazaar'],
								'permission' => ['MANAGE_LOGS', 'MANAGE_BAZAAR'],
							]
						]
					]
				]
			],
			'misc' => [
				'title' => t__('Misc'),
				'icon' => 'category-2',
				'module' => ['games', 'leaderboards', 'lottery', 'vote', 'slider', 'announcements', 'download', 'suggestions', 'bazaar'],
				'permission' => ['VIEW_STATS', 'MANAGE_GAMES', 'MANAGE_LEADERBOARDS', 'MANAGE_LOTTERY', 'MANAGE_VOTES', 'MANAGE_SLIDER', 'MANAGE_ANNOUNCEMENTS', 'MANAGE_DOWNLOADS', 'MANAGE_SUGGESTIONS', 'MANAGE_BAZAAR'],
				'items' => [
					[
						'title' => t__('Misc'),
						'items' => [
							[
								'title' => t__('Statistics'),
								'route' => 'dashboard.stats.index',
								'category' => 'misc.stats',
								'icon' => 'diagram',
								'permission' => ['VIEW_STATS'],
							],
							[
								'title' => t__('Gamemodes'),
								'route' => 'dashboard.games.index',
								'category' => 'misc.games',
								'icon' => 'game',
								'module' => ['games'],
								'permission' => ['MANAGE_GAMES'],
								'items' => [
									[
										'title' => t__('Create Gamemodes'),
										'route' => 'dashboard.games.create',
										'icon' => 'game',
										'permission' => ['MANAGE_GAMES'],
									]
								]
							],
							[
								'title' => t__('Leaderboards'),
								'route' => 'dashboard.leaderboards.index',
								'category' => 'misc.leaderboards',
								'icon' => 'cup',
								'module' => ['leaderboards'],
								'permission' => ['MANAGE_LEADERBOARDS'],
								'items' => [
									[
										'title' => t__('Create Leaderboard'),
										'route' => 'dashboard.leaderboards.create',
										'icon' => 'cup',
										'permission' => ['MANAGE_LEADERBOARDS'],
									]
								]
							],
							[
								'title' => t__('Fortune Wheel'),
								'route' => 'dashboard.lotteries.index',
								'category' => 'misc.lotteries',
								'icon' => 'graph',
								'module' => ['lottery'],
								'permission' => ['MANAGE_LOTTERY'],
								'items' => [
									[
										'title' => t__('Create Fortune Wheel'),
										'route' => 'dashboard.lotteries.create',
										'icon' => 'graph',
										'permission' => ['MANAGE_LOTTERY'],
									]
								]
							],
							[
								'title' => t__('Vote'),
								'route' => 'dashboard.votes.index',
								'category' => 'misc.votes',
								'icon' => 'like-1',
								'module' => ['vote'],
								'permission' => ['MANAGE_VOTES'],
								'items' => [
									[
										'title' => t__('Create Vote'),
										'route' => 'dashboard.votes.create',
										'icon' => 'like-1',
										'permission' => ['MANAGE_VOTES'],
									]
								]
							],
							[
								'title' => t__('Slider'),
								'route' => 'dashboard.sliders.index',
								'category' => 'misc.slider',
								'icon' => 'slider-horizontal',
								'module' => ['slider'],
								'permission' => ['MANAGE_SLIDER'],
								'items' => [
									[
										'title' => t__('Create Slider'),
										'route' => 'dashboard.sliders.create',
										'icon' => 'slider-horizontal',
										'permission' => ['MANAGE_SLIDER'],
									]
								]
							],
							[
								'title' => t__('Announcements'),
								'route' => 'dashboard.announcements.index',
								'category' => 'misc.announcements',
								'icon' => 'volume-low-1',
								'module' => ['announcements'],
								'permission' => ['MANAGE_ANNOUNCEMENTS'],
								'items' => [
									[
										'title' => t__('Create Announcement'),
										'route' => 'dashboard.announcements.create',
										'icon' => 'volume-low-1',
										'permission' => ['MANAGE_ANNOUNCEMENTS'],
									]
								]
							],
							[
								'title' => t__('Download Center'),
								'route' => 'dashboard.downloads.index',
								'category' => 'misc.downloads',
								'icon' => 'cloud',
								'module' => ['download'],
								'permission' => ['MANAGE_DOWNLOADS'],
								'items' => [
									[
										'title' => t__('Create File'),
										'route' => 'dashboard.downloads.create',
										'icon' => 'cloud',
										'permission' => ['MANAGE_DOWNLOADS'],
									]
								]
							],
							[
								'title' => t__('Suggestions'),
								'category' => 'misc.suggestions',
								'icon' => 'lamp-charge',
								'module' => ['suggestions'],
								'permission' => ['MANAGE_SUGGESTIONS'],
								'items' => [
									[
										'title' => t__('Suggestions'),
										'route' => 'dashboard.suggestions.index',
										'category' => 'misc.suggestions.suggestions',
										'icon' => 'lamp-charge'
									],
									[
										'title' => t__('Categories'),
										'route' => 'dashboard.suggestions.categories.index',
										'category' => 'misc.suggestions.categories',
										'icon' => 'category-2',
										'items' => [
											[
												'title' => t__('Create Category'),
												'route' => 'dashboard.suggestions.categories.create',
												'icon' => 'category-2',
												'permission' => ['MANAGE_SUGGESTIONS'],
											]
										]
									]
								]
							],
							[
								'title' => t__('Bazaar'),
								'category' => 'misc.bazaar',
								'icon' => 'shop',
								'module' => ['bazaar'],
								'permission' => ['MANAGE_BAZAAR'],
								'items' => [
									[
										'title' => t__('Items'),
										'route' => 'dashboard.bazaar.index',
										'category' => 'misc.bazaar.items',
										'icon' => 'shop'
									],
									[
										'title' => t__('Servers'),
										'route' => 'dashboard.bazaar.servers.index',
										'category' => 'misc.bazaar.servers',
										'icon' => 'category-2',
										'items' => [
											[
												'title' => t__('Create Server'),
												'route' => 'dashboard.bazaar.servers.create',
												'icon' => 'category-2',
												'permission' => ['MANAGE_BAZAAR'],
											]
										]
									],
									[
										'title' => t__('Custom Item Images'),
										'route' => 'dashboard.bazaar.custom-item-images.index',
										'category' => 'misc.bazaar.custom-item-images',
										'icon' => 'gallery',
										'items' => [
											[
												'title' => t__('Create Custom Item Image'),
												'route' => 'dashboard.bazaar.custom-item-images.create',
												'icon' => 'gallery',
												'permission' => ['MANAGE_BAZAAR'],
											]
										]
									],
									[
										'title' => t__('Settings'),
										'route' => 'dashboard.settings.bazaar.index',
										'category' => 'settings.bazaar',
										'icon' => 'setting-2',
									]
								]
							],
							[
								'title' => t__('URL Redirects'),
								'route' => 'dashboard.redirects.index',
								'category' => 'misc.redirects',
								'icon' => 'link',
								'permission' => ['MANAGE_SETTINGS'],
								'items' => [
									[
										'title' => t__('Create URL Redirect'),
										'route' => 'dashboard.redirects.create',
										'icon' => 'link',
										'permission' => ['MANAGE_SETTINGS'],
									]
								]
							],
							[
								'title' => t__('Popup'),
								'route' => 'dashboard.popup.edit',
								'category' => 'misc.popup',
								'icon' => 'copy',
								'module' => ['popup'],
								'permission' => ['MANAGE_SETTINGS'],
							],
						]
					]
				]
			],
			'settings' => [
				'title' => t__('Settings'),
				'permission' => ['MANAGE_SETTINGS', 'MANAGE_PAYMENT', 'MANAGE_MODULES', 'MANAGE_UPDATES'],
				'items' => [
					[
						'title' => t__('Settings'),
						'items' => [
							[
								'title' => t__('General'),
								'route' => 'dashboard.settings.general.index',
								'category' => 'settings.general',
								'icon' => 'setting-5',
								'permission' => ['MANAGE_SETTINGS'],
							],
							[
								'title' => t__('System'),
								'route' => 'dashboard.settings.system.index',
								'category' => 'settings.system',
								'icon' => 'cpu',
								'permission' => ['MANAGE_SETTINGS'],
							],
							[
								'title' => t__('Payment Methods'),
								'route' => LOCATION == 'TR' ? 'payment-gateways.index' : 'payment-gateways.tebex',
								'category' => 'settings.payment-gateways',
								'icon' => 'card-add',
								'permission' => ['MANAGE_PAYMENT'],
							],
							[
								'title' => t__('Currencies'),
								'route' => 'dashboard.settings.currencies.index',
								'category' => 'settings.currencies',
								'icon' => 'money-send',
								'permission' => ['MANAGE_SETTINGS'],
								'items' => [
									[
										'title' => t__('Create Currency'),
										'route' => 'dashboard.settings.currencies.create',
										'icon' => 'money-send',
										'permission' => ['MANAGE_SETTINGS'],
									]
								]
							],
							[
								'title' => t__('SEO'),
								'route' => 'dashboard.settings.seo.index',
								'category' => 'settings.seo',
								'icon' => 'search-status',
								'permission' => ['MANAGE_SETTINGS'],
							],
							[
								'title' => t__('Languages'),
								'route' => 'dashboard.settings.languages.index',
								'category' => 'settings.languages',
								'icon' => 'language-square',
								'permission' => ['MANAGE_SETTINGS'],
								'items' => [
									[
										'title' => t__('Create Language'),
										'route' => 'dashboard.settings.languages.create',
										'icon' => 'language-square',
										'permission' => ['MANAGE_SETTINGS'],
									]
								]
							],
							[
								'title' => t__('Discord Webhooks'),
								'route' => 'dashboard.discord-webhooks.index',
								'category' => 'settings.discord-webhooks',
								'icon' => 'webhook',
								'permission' => ['MANAGE_SETTINGS'],
								'items' => [
									[
										'title' => t__('Create Discord Webhook'),
										'route' => 'dashboard.discord-webhooks.create',
										'icon' => 'webhook',
										'permission' => ['MANAGE_SETTINGS'],
									]
								]
							],
							[
								'title' => t__('SMTP'),
								'route' => 'dashboard.settings.smtp.index',
								'category' => 'settings.smtp',
								'icon' => 'directbox-send',
								'permission' => ['MANAGE_SETTINGS'],
							],
							[
								'title' => t__('Email Templates'),
								'route' => 'dashboard.settings.email-templates.index',
								'category' => 'settings.email-templates',
								'icon' => 'directbox-notif',
								'permission' => ['MANAGE_SETTINGS'],
							],
							[
								'title' => t__('Discord Bot'),
								'route' => 'dashboard.settings.discord-bot.index',
								'category' => 'settings.discord-bot',
								'icon' => 'discord',
								'module' => ['discord_bot'],
								'permission' => ['MANAGE_SETTINGS'],
							],
							[
								'title' => t__('Punishments'),
								'route' => 'dashboard.settings.punishments.index',
								'category' => 'settings.punishments',
								'icon' => 'forbidden',
								'module' => ['punishments'],
								'permission' => ['MANAGE_SETTINGS'],
							],
							[
								'title' => t__('Paraşüt'),
								'route' => 'dashboard.settings.parasut.index',
								'category' => 'settings.parasut',
								'icon' => 'document-text',
								'module' => ['parasut'],
								'permission' => ['MANAGE_SETTINGS'],
							],
							[
								'title' => t__('BirFatura'),
								'route' => 'dashboard.settings.birfatura.index',
								'category' => 'settings.birfatura',
								'icon' => 'document-text',
								'module' => ['birfatura'],
								'permission' => ['MANAGE_SETTINGS'],
							],
							[
								'title' => t__('Modules'),
								'route' => 'dashboard.modules.index',
								'category' => 'settings.modules',
								'icon' => 'category',
								'permission' => ['MANAGE_MODULES'],
							],
							[
								'title' => t__('API'),
								'route' => 'dashboard.settings.api.index',
								'category' => 'settings.api',
								'icon' => 'data',
								'permission' => ['MANAGE_SETTINGS'],
							],
							[
								'title' => t__('Updates'),
								'route' => 'dashboard.updates.index',
								'category' => 'settings.updates',
								'icon' => 'refresh-2',
								'permission' => ['MANAGE_UPDATES'],
							]
						]
					],
				]
			],
		];
	}
	
	public function search($query)
	{
		$this->processArray($this->array);
		
		$fuse = new Fuse($this->processed, [
			'keys' => ['title', 'breadcrumb'],
			'minMatchCharLength' => 3,
			'threshold' => 0.4,
			'ignoreLocation' => true
		]);
		
		return array_slice($fuse->search($query), 0,self::MAX_RESULTS);
	}
	
  private function processArray($array, $breadcrumb = '') {
	  foreach ($array as $item) {
		  if (isset($item["module"]) && !checkModuleStatus($item["module"])) {
			  continue;
		  }
		  
		  if (isset($item["permission"]) && !auth()->user()->can($item["permission"])) {
			  continue;
		  }
		  
		  if (isset($item["show"]) && !$item["show"]) {
			  continue;
		  }
			
		  $separator = ' > ';
		  $currentBreadcrumb = $breadcrumb;
		  if (isset($item['title']) && is_string($item['title'])) {
				$itemTitle = t__($item['title']);
			  if ($currentBreadcrumb !== '' && $itemTitle !== $currentBreadcrumb) {
				  $currentBreadcrumb .= $separator .$itemTitle;
			  } else {
				  $currentBreadcrumb = $itemTitle;
			  }
		  }
			
		  if (isset($item['route'])) {
			  $this->processed[] = [
				  'title' => t__($item['title']),
				  'breadcrumb' => $currentBreadcrumb,
				  'url' => url($item['route']),
				  'icon' => $item['icon'] ?? 'shopping-cart',
			  ];
		  }
		  
		  if (isset($item['items']) && is_array($item['items'])) {
			  self::processArray($item['items'], $currentBreadcrumb);
		  }
	  }
  }
}