<?php
namespace Dashboard\Services;

use PDO;

class SlugService
{
  public static function preventDuplicate($slug, $table = 'ProductCategories'): string
  {
    $slug = slugify($slug);

    $slugs = db()->prepare("SELECT slug FROM $table WHERE slug LIKE ?");
    $slugs->execute([$slug."-%"]);
    $slugs = $slugs->fetchAll(PDO::FETCH_ASSOC);
    $lastSlugID = null;
    foreach ($slugs as $checkSlug) {
      if (preg_match("/".$slug."-([0-9]+)/", $checkSlug["slug"], $matches)) {
        if ($matches[1] > $lastSlugID) {
          $lastSlugID = $matches[1];
        }
      }
    }
    if ($lastSlugID === null) {
      $slugs = db()->prepare("SELECT id FROM $table WHERE slug = ?");
      $slugs->execute([$slug]);
      $slugs = $slugs->fetchAll(PDO::FETCH_ASSOC);
      if (count($slugs) > 0) {
        $lastSlugID = 0;
      }
    }
    if ($lastSlugID !== null) {
      $slug .= "-" . ($lastSlugID + 1);
    }
    return $slug;
  }
}