<?php
	$plans = [
		'ai' => [
			'name' => 'AI',
			'description' => t__('The essentials to provide your best work for players with limited AI capabilities.'),
			'price' => '£6.99',
			'price_tr' => '299 TL',
			'features' => [
				t__('%limit% "Generate with AI" content generations per month', ['%limit%' => '250']),
				t__('%limit% auto-replies to support tickets per month', ['%limit%' => '250']),
				t__('%limit% in-game /ai command usage per month', ['%limit%' => '250']),
				t__('%limit% Discord /ai command usage per month', ['%limit%' => '250']),
				t__('Up to %limit% data sources', ['%limit%' => '3']),
				t__('Basic analytics and reporting'),
				t__('Basic support'),
			]
		],
		'ai-plus' => [
			'name' => 'AI+',
			'description' => t__('A plan that scales with your rapidly growing business, offering unlimited content creation.'),
			'price' => '£9.99',
			'price_tr' => '499 TL',
			'features' => [
				t__('%limit% "Generate with AI" content generations per month', ['%limit%' => '500']),
				t__('%limit% auto-replies to support tickets per month', ['%limit%' => '500']),
				t__('%limit% in-game /ai command usage per month', ['%limit%' => '500']),
				t__('%limit% Discord /ai command usage per month', ['%limit%' => '500']),
				t__('Up to %limit% data sources', ['%limit%' => '5']),
				t__('Advanced analytics and reporting'),
				t__('2x faster response times than the AI plan'),
				t__('Priority support'),
			]
		],
		'ai-enterprise' => [
			'name' => 'AI Enterprise',
			'description' => t__('Dedicated support and fully customizable AI capabilities tailored to your business needs.'),
			'price' => t__('Contact us'),
			'price_tr' => t__('Contact us'),
			'features' => [
				t__('Custom "Generate with AI" content generation limits'),
				t__('Custom in-game /ai command usage limits'),
				t__('Custom Discord /ai command usage limits'),
				t__('Custom Data Sources limits'),
				t__('Advanced analytics and custom reporting'),
				t__('Dedicated support'),
				t__('Custom AI model training'),
				t__('Usage-based pricing optimization')
			]
		]
	];
?>

<div class="isolate mx-auto mt-10 grid max-w-md grid-cols-1 gap-6 lg:mx-0 lg:max-w-none lg:grid-cols-3 text-left">
	<?php foreach ($plans as $plan_id => $plan): ?>
		<div class="card p-8 xl:p-10">
			<h3 id="tier-freelancer" class="text-xl font-semibold leading-8 text-gray-800">
				<?php echo $plan['name'] ?>
			</h3>
			<p class="mt-4 text-sm leading-6 text-gray-500">
				<?php echo $plan['description'] ?>
			</p>
			<p class="mt-6 flex items-baseline gap-x-1">
				<span class="text-4xl font-bold tracking-tight text-gray-800">
					<?php if (LOCATION === 'TR'): ?>
					    <?php echo $plan['price_tr'] ?>
					<?php else: ?>
				    <?php echo $plan['price'] ?>
					<?php endif; ?>
				</span>
				<?php if ($plan_id !== 'ai-enterprise'): ?>
					<span class="text-sm font-semibold leading-6 text-gray-500">/<?php e__('month') ?></span>
				<?php endif; ?>
			</p>
			<?php if ($plan_id === 'ai-enterprise'): ?>
				<a href="<?php echo LOCATION === 'TR' ? 'https://www.leaderos.com.tr/iletisim' : 'https://www.leaderos.net/contact' ?>" target="_blank" class="mt-6 btn btn-primary block text-center !py-3">
					<?php e__('Contact us') ?>
				</a>
			<?php else: ?>
				<a href="<?php echo LOCATION === 'TR' ? 'https://www.leaderos.com.tr/odeme/ai/' . $plan_id : 'https://www.leaderos.net/checkout/ai/' . $plan_id ?>" target="_blank" class="mt-6 btn btn-primary block text-center !py-3">
					<?php e__('Subscribe') ?>
				</a>
			<?php endif; ?>
			<ul role="list" class="mt-8 space-y-3 text-sm leading-6 text-gray-600 xl:mt-10">
				<?php foreach ($plan["features"] as $plan_feature): ?>
					<li class="flex gap-x-3">
						<svg class="h-6 w-5 flex-none text-blue-500" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
							<path fill-rule="evenodd" d="M16.704 4.153a.75.75 0 01.143 1.052l-8 10.5a.75.75 0 01-1.127.075l-4.5-4.5a.75.75 0 011.06-1.06l3.894 3.893 7.48-9.817a.75.75 0 011.05-.143z" clip-rule="evenodd" />
						</svg>
						<?php echo $plan_feature; ?>
					</li>
				<?php endforeach; ?>
			</ul>
		</div>
	<?php endforeach; ?>
</div>