<?php $usagePercent = ($limit == -1) ? 0 : min(100, round(($usage / $limit) * 100)); ?>
<div class="card p-6">
	<h5 class="card-title">
		<?php echo $title; ?>
	</h5>
	<div>
		<span class="h3 text-gray-950">
			<?php echo $usage ?>/<?php echo $limit == -1 ? '∞' : $limit ?>
		</span>
	</div>
	
	<div class="mt-4">
		<div class="w-full bg-gray-900/10 dark:bg-white/5 rounded-full h-4 overflow-hidden">
			<?php if ($usage >= $limit): ?>
				<div class="bg-red-500 h-full rounded-r-md" style="width: <?php echo $usagePercent; ?>%;"></div>
			<?php elseif ($usagePercent > 70): ?>
				<div class="bg-orange-500 h-full rounded-r-md" style="width: <?php echo $usagePercent; ?>%;"></div>
			<?php else: ?>
				<div class="bg-blue-600 h-full rounded-r-md" style="width: <?php echo $usagePercent; ?>%;"></div>
			<?php endif; ?>
		</div>
	</div>
</div>