<div class="card mt-4">
  <div class="py-4 px-5 flex justify-between items-center">
    <h5 class="card-title"><?php e__('Command Logs') ?></h5>
    <?php
    $showSendAllButton = false;
		$commandLogs = array_map(function ($commandLog) {
			if ($commandLog["status"] == 'sending' && $commandLog["updatedAt"] <= date('Y-m-d H:i:s', strtotime('-1 minutes'))) {
				$commandLog["status"] = 'timeout';
			}
			
			return $commandLog;
		}, $commandLogs);
    foreach ($commandLogs as $commandLog) {
      if ($commandLog["status"] == 'error' || $commandLog["status"] == 'timeout') {
        $showSendAllButton = true;
        break;
      }
    }
    ?>
    <?php if ($showSendAllButton): ?>
      <form action="<?php echo url('dashboard.command-logs.sendAll') ?>" method="post">
        <?php _csrf(); ?>
        <input type="hidden" name="dataType" value="<?php echo $dataType ?>">
        <input type="hidden" name="dataID" value="<?php echo $dataID ?>">
        <button type="submit" class="btn btn-success btn-sm">
          <?php e__('Retry failed commands') ?>
        </button>
      </form>
    <?php endif; ?>
  </div>
  <div class="">
    <table class="table">
      <colgroup>
        <col style="width: 50%;">
      </colgroup>
      <thead>
      <tr class="table-header">
        <th scope="col" class="text-left">
          <?php e__('Command') ?>
        </th>
        <th scope="col" class="text-left">
          <?php e__('Product') ?>
        </th>
        <th scope="col" class="text-left">
          <?php e__('Server') ?>
        </th>
        <th scope="col">
          <?php e__('Status') ?>
        </th>
        <th scope="col">
          <?php e__('Date') ?>
        </th>
        <th scope="col" class="!text-right">
          <span class="sr-only">
              <?php e__('Actions') ?>
          </span>
        </th>
      </tr>
      </thead>
      <tbody>
      <?php foreach ($commandLogs as $commandLog): ?>
        <tr x-data="sendAgainCommand('<?php echo $commandLog['id']; ?>', '<?php echo $commandLog["status"] ?>', '<?php echo convertTime($commandLog["updatedAt"], 2, true) ?>', '<?php echo convertTime($commandLog["updatedAt"]) ?>')">
          <td class="!text-left">
            <span class="text-sm text-gray-500">
              <?php echo $commandLog['command']; ?>
            </span>
          </td>
          <td>
            <div class="text-sm text-gray-500 line-clamp-2 max-w-sm block"><?php echo $commandLog['productName'] ?></div>
          </td>
          <td>
            <div class="text-sm text-gray-500 line-clamp-2 max-w-sm block"><?php echo $commandLog['serverName'] ?></div>
          </td>
          <td>
            <div class="text-sm text-gray-500 line-clamp-2 max-w-sm block">
              <span x-show="status === 'completed'" class="badge badge-success"><?php e__('Success') ?></span>
              <span x-show="status === 'sending'" class="badge badge-info"><?php e__('Sending') ?></span>
              <span x-show="status === 'waiting'" class="badge badge-warning"><?php e__('Waiting') ?></span>
              <span x-show="status === 'timeout'" class="badge badge-danger"><?php e__('Timeout') ?></span>
              <span x-show="status === 'error'" class="badge badge-danger"><?php e__('Failed') ?></span>
            </div>
          </td>
          <td>
            <div class="text-sm text-gray-700 font-medium" x-text="dateLong"></div>
            <div class="text-xs text-gray-500" x-text="dateShort"></div>
          </td>
          <td class="table-action-buttons">
            <?php if ($commandLog["status"] == 'error' || $commandLog["status"] == 'timeout'): ?>
              <button
                x-show="status === 'error' || status === 'timeout'"
                x-bind="tooltip('<?php e__('Send Again') ?>')"
                type="button"
                class="btn btn-sm btn-icon btn-success"
                :class="isLoading && 'opacity-75 pointer-events-none'"
                @click="sendAgain()"
              >
                <i class="stroke-white stroke-2 w-4" x-show="!isLoading" data-feather="refresh-2"></i>
                <svg x-show="isLoading" class="animate-spin h-4 w-4 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                  <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                  <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                </svg>
              </button>
            <?php endif; ?>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>