<div x-show="showVariables !== false" class="fixed inset-0" style="z-index: 99;">
	<div @click="showVariables = false" class="absolute inset-0 bg-black/50 backdrop-blur-[1px]"></div>
	<div class="max-w-xl w-full card p-3 absolute-center -mt-20 duration-200 transition relative"
	     x-transition:enter-start="opacity-0 scale-90"
	     x-transition:enter-end="opacity-100 scale-100"
	     x-transition:leave-start="opacity-100 scale-100"
	     x-transition:leave-end="opacity-0 scale-90">
		<div class="py-4 px-6 flex justify-between items-center">
			<div class="text-los font-medium font-maven text-xl"><?php e__('Variables') ?></div>
			<div @click="showVariables = false" class="cursor-pointer text-sm text-gray-400/75 transition hover:text-gray-400">
				<svg class="w-4 fill-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
					<path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"></path>
				</svg>
			</div>
		</div>
		<div class="py-4 px-6 grid gap-4">
			<table class="table">
				<thead>
				<tr class="table-header dark:!bg-black">
					<th class="text-left"><?php e__('Variable') ?></th>
					<th class="text-left"><?php e__('Replaces with') ?></th>
				</tr>
				</thead>
				<tbody>
				<?php if (settings('loginProvider') == 'default'): ?>
					<tr>
						<td class="text-gray-950">%username%</td>
						<td class="text-gray-400"><?php e__('Username') ?></td>
					</tr>
				<?php endif; ?>
				<?php if (settings('loginProvider') == 'minecraft'): ?>
					<tr>
						<td class="text-gray-950">%username%</td>
						<td class="text-gray-400"><?php e__('Username') ?></td>
					</tr>
					<tr>
						<td class="text-gray-950">%uuid%</td>
						<td class="text-gray-400"><?php e__('UUID') ?></td>
					</tr>
				<?php endif; ?>
				<?php if (settings('loginProvider') == 'steam'): ?>
					<tr>
						<td class="text-gray-950">%display_name%</td>
						<td class="text-gray-400"><?php e__('Display Name') ?></td>
					</tr>
					<tr>
						<td class="text-gray-950">%steam_id%</td>
						<td class="text-gray-400"><?php e__('Steam ID') ?></td>
					</tr>
				<?php endif; ?>
				<?php if (settings('loginProvider') == 'discord'): ?>
					<tr>
						<td class="text-gray-950">%username%</td>
						<td class="text-gray-400"><?php e__('Username') ?></td>
					</tr>
					<tr>
						<td class="text-gray-950">%discord_id%</td>
						<td class="text-gray-400"><?php e__('Discord ID') ?></td>
					</tr>
				<?php endif; ?>
				<?php if (settings('loginProvider') == 'cfx'): ?>
					<tr>
						<td class="text-gray-950">%username%</td>
						<td class="text-gray-400"><?php e__('Username') ?></td>
					</tr>
					<tr>
						<td class="text-gray-950">%cfx_id%</td>
						<td class="text-gray-400"><?php e__('Cfx.re ID') ?></td>
					</tr>
				<?php endif; ?>
				<?php if (settings('loginProvider') != 'default' && settings('gameType') == 'fivem'): ?>
					<tr>
						<td class="text-gray-950">%sid%</td>
						<td class="text-gray-400">
							<?php e__('Source ID') ?> (<?php e__('Requires LeaderOS Connect') ?>)
						</td>
					</tr>
				<?php endif; ?>
				<?php foreach ($account_linking_providers as $account_linking_provider): ?>
					<?php if ($account_linking_provider["slug"] == 'minecraft'): ?>
						<tr x-show="selectedProviders.includes(<?php echo $account_linking_provider["id"]; ?>)">
							<td class="text-gray-950">%<?php echo $account_linking_provider["slug"] ?>_uuid%</td>
							<td class="text-gray-400"><?php echo $account_linking_provider["name"] ?> UUID</td>
						</tr>
					<?php else: ?>
						<tr x-show="selectedProviders.includes(<?php echo $account_linking_provider["id"]; ?>)">
							<td class="text-gray-950">%<?php echo $account_linking_provider["slug"] ?>_id%</td>
							<td class="text-gray-400"><?php echo $account_linking_provider["name"] ?> ID</td>
						</tr>
					<?php endif; ?>
					<tr x-show="selectedProviders.includes(<?php echo $account_linking_provider["id"]; ?>)">
						<td class="text-gray-950">%<?php echo $account_linking_provider["slug"] ?>_username%</td>
						<td class="text-gray-400"><?php echo $account_linking_provider["name"] ?> <?php e__('Username') ?></td>
					</tr>
				<?php endforeach; ?>
				<?php foreach ($custom_variables as $custom_variable): ?>
					<tr x-show="selectedVariables.includes(<?php echo $custom_variable["id"]; ?>)">
						<td class="text-gray-950">%<?php echo $custom_variable["identifier"] ?>%</td>
						<td class="text-gray-400"><?php echo $custom_variable["name"] ?></td>
					</tr>
				<?php endforeach; ?>
				</tbody>
			</table>
		</div>
	</div>
</div>