<li class="dd-item advancedproductlisting-dd-item" x-data="{ expanded: true }" data-type="category" data-id="<?php echo $category["id"] ?>" data-group-id="<?php echo $category["parentID"] ?>">
  <div class="bg-gray-200 dark:bg-los-deep py-2 px-4 text-gray-800 flex items-center justify-between mt-1 rounded-xl <?php echo (count($category["products"]) > 0 || (count($category["subcategories"]) === 0 && !isset($isSubCategory))) ? "!rounded-br-none" : null ?>">
    <div class="flex items-center gap-3">
      <i data-feather="menu" class="w-5 h-5 cursor-move dd-handle"></i>

      <a href="<?php echo url('dashboard.store.categories.edit', ['id' => $category["id"]]) ?>" class="font-medium text-sm hover:!text-gray-800 dark:hover:!text-gray-400">
          <?php echo $category["name"] ?>
        </a>
    </div>
    <div class="flex items-center gap-3 select-none text-gray-800">
      <div x-data="dropdown()" class="relative">
        <div @click="toggle()" x-bind="tooltip('<?php e__('Actions') ?>')" class="cursor-pointer w-9 h-9 center rounded-xl transition hover:bg-gray-600/10">
          <svg class="w-4 stroke-current" fill="none" viewBox="0 0 11 3" xmlns="http://www.w3.org/2000/svg">
            <path d="M9.93947 1.01312H9.94847" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
            <path d="M5.93044 1.01312H5.93944" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
            <path d="M1.9214 1.01312H1.9304" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
          </svg>
        </div>

        <div x-bind="isDropdown" class="dropdown">
          <a href="<?php echo url('dashboard.store.categories.edit', ['id' => $category["id"]]) ?>">
            <?php e__('Edit') ?>
          </a>
          <form action="<?php echo url('dashboard.store.categories.destroy', ['id' => $category['id']]) ?>" method="post" x-data="deleteConfirmation()">
            <?php _method('DELETE'); ?>
            <?php _csrf(); ?>
            <button type="submit" class="text-left !text-red-500">
              <?php e__('Delete') ?>
            </button>
          </form>
        </div>
      </div>

      <div @click="expanded = ! expanded" class="cursor-pointer w-9 h-9 center rounded-xl transition hover:bg-gray-600/10">
        <svg :class="{'rotate-180':!expanded}" class="transition-all w-3 fill-current" viewBox="0 0 16 10" xmlns="http://www.w3.org/2000/svg">
          <path d="M15.5303 9.03045C15.2641 9.29672 14.8474 9.32092 14.5538 9.10307L14.4697 9.03045L8 2.56112L1.53033 9.03045C1.26406 9.29672 0.8474 9.32092 0.553788 9.10307L0.46967 9.03045C0.203403 8.76419 0.179197 8.34752 0.397052 8.05391L0.46967 7.96979L7.46967 0.969792C7.73594 0.703526 8.1526 0.679319 8.44621 0.897174L8.53033 0.969792L15.5303 7.96979C15.8232 8.26269 15.8232 8.73756 15.5303 9.03045Z"/>
        </svg>
      </div>
    </div>
  </div>
  <?php if (count($category["subcategories"]) > 0 || count($category["products"]) > 0 || (count($category["subcategories"]) === 0 && !isset($isSubCategory))): ?>
    <ol data-type="group" data-group-id="<?php echo $category["id"] ?>" class="dd-list ml-6 relative rounded-b-xl !mb-4" x-show="expanded" x-collapse.duration.500ms>
      <?php foreach ($category["subcategories"] as $subcategory): ?>
        <?php
        $this->insert('components/products-tree/category', [
          'category' => $subcategory,
          'isSubCategory' => true,
        ]);
        ?>
      <?php endforeach; ?>
      <?php if (count($category["products"]) > 0): ?>
        <?php foreach ($category["products"] as $product): ?>
          <?php
          $this->insert('components/products-tree/product', [
            'product' => $product,
            'categoryID' => $category["id"],
          ]);
          ?>
        <?php endforeach; ?>
      <?php else: ?>
        <?php if (count($category["subcategories"]) === 0 && !isset($isSubCategory)): ?>
          <div class="bg-gray-100 dark:bg-los-deep/90 py-3 px-6 flex justify-between items-center rounded-b-xl">
            <a class="text-gray-500 text-sm" href="<?php echo url('dashboard.store.products.create') ?>">
              <?php e__('Drag a item here or create one.') ?>
            </a>
          </div>
        <?php endif; ?>
      <?php endif; ?>
    </ol>
  <?php endif; ?>
</li>