<li data-type="product" data-id="<?php echo $product["id"] ?>" data-group-id="<?php echo $categoryID ?>" class="dd-item advancedproductlisting-dd-item bg-gray-100 dark:bg-los-deep/90 hover:bg-gray-50 dark:hover:bg-los-shiny/50 !py-2 !px-4 !flex justify-between items-center text-gray-800">
  <div class="flex items-center gap-3">
    <i data-feather="menu" class="w-5 h-5 cursor-move dd-handle"></i>

    <a href="<?php echo url('dashboard.store.products.edit', ['id' => $product["id"]]) ?>" class="text-sm hover:!text-gray-800 dark:hover:!text-gray-400">
      <span>
        <?php echo $product["name"] ?>
      </span>
      <span>-</span>
      <span class="text-gray-500 dark:text-gray-400">
        <?php if (moduleSettings('store', 'isCreditRequiredOnPurchase') == 1): ?>
          <?php echo credits($product["price"]); ?>
        <?php else: ?>
          <?php echo money($product["price"]); ?>
        <?php endif; ?>
      </span>
    </a>
  </div>
  <div>
    <div x-data="dropdown()" class="relative">
      <div @click="toggle()" x-bind="tooltip('<?php e__('Actions') ?>')" class="cursor-pointer w-9 h-9 center rounded-xl transition hover:bg-gray-600/10">
        <svg class="w-4 stroke-current" fill="none" viewBox="0 0 11 3" xmlns="http://www.w3.org/2000/svg">
          <path d="M9.93947 1.01312H9.94847" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
          <path d="M5.93044 1.01312H5.93944" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
          <path d="M1.9214 1.01312H1.9304" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
        </svg>
      </div>

      <div x-bind="isDropdown" class="dropdown">
        <a href="<?php echo url('dashboard.store.products.edit', ['id' => $product["id"]]) ?>">
          <?php e__('Edit') ?>
        </a>
	      <a href="<?php echo url('dashboard.store.products.clone', ['id' => $product["id"]]) ?>">
		      <?php e__('Clone') ?>
	      </a>
        <form action="<?php echo url('dashboard.store.products.destroy', ['id' => $product['id']]) ?>" method="post" x-data="deleteConfirmation()">
          <?php _method('DELETE'); ?>
          <?php _csrf(); ?>
          <button type="submit" class="text-left !text-red-500">
            <?php e__('Delete') ?>
          </button>
        </form>
      </div>
    </div>
  </div>
</li>