<?php
  $funcArgs = [];
  if (isset($selected)) {
    $funcArgs[] = (is_array($selected) ? htmlentities(json_encode($selected)) : "'" . $selected . "'");
  } else if (isset($selectedJS)) {
    $funcArgs[] = $selectedJS;
  }  else {
    $funcArgs[] = 'null';
  }
  if (isset($list)) {
    $funcArgs[] = htmlentities(json_encode($list));
  }
	if (isset($multiple)) {
		$funcArgs[] = 'true';
	}
  $funcArgs = implode(', ', $funcArgs);
?>

<select
  x-data="selectProduct(<?php echo $funcArgs ?>)"
  name="<?php echo $name; ?>"
  id="<?php echo $id ?? null; ?>"
  <?php echo isset($multiple) ? 'multiple' : null; ?>
  <?php echo isset($placeholder) ? 'placeholder="'. $placeholder .'"' : null; ?>
  <?php echo isset($disabledJS) ? ':disabled="'. $disabledJS .'"' : null; ?>
  <?php echo isset($onChange) ? 'x-init="onChange('. $onChange .')"' : null; ?>
>
  <?php if (isset($placeholder)): ?>
    <option></option>
  <?php endif; ?>
</select>