<div
    x-data="{
      isLoading: false,
      on: parseInt(<?php echo $default ?>),
      init() {
				<?php echo isset($init) ? $init : null ?>
			},
      async handleToggle(func = () => {}) {
        this.on = this.on === 1 ? 0 : 1;
        this.isLoading = true;
        await func();
        this.isLoading = false;
      },
    }"
    <?php echo ((isset($labelLeft) || isset($labelRight)) ? 'class="flex items-center gap-2"' : ''); ?>
>
    <?php if (isset($labelTop)): ?>
        <label
                class="form-label cursor-pointer select-none"
                @click="handleToggle(async () => { <?php echo isset($action) ? $action : null ?> })"
        >
            <?php echo $labelTop; ?>
        </label>
    <?php endif; ?>

    <?php if (isset($labelLeft)): ?>
        <label
            class="form-label cursor-pointer select-none !mb-0"
            @click="handleToggle(async () => { <?php echo isset($action) ? $action : null ?> })"
        >
            <?php echo $labelLeft; ?>
        </label>
    <?php endif; ?>
    <div class="flex">
        <input type="hidden" <?php echo (isset($disabled) && $disabled) ? 'disabled' : null ?> name="<?php echo $name ?>" x-model="on">
        <button
                type="button"
                class="toggle-switch"
                <?php echo (isset($disabled) && $disabled) ? 'disabled' : null ?>
                role="switch"
                aria-checked="false"
                :aria-checked="on.toString()"
                @click="handleToggle(async () => { <?php echo isset($action) ? $action : null ?> })"
                x-state:on="Enabled"
                x-state:off="Not Enabled"
                :class="{
                  '!bg-blue-600': on,
                  '!bg-gray-200 dark:!bg-gray-200/20': !(on),
                  'pointer-events-none': isLoading,
                  'opacity-50': isLoading
                }"
        >
            <span x-state:on="Enabled" x-state:off="Not Enabled" :class="{ '!translate-x-5': on, '!translate-x-0': !(on) }">
              <span :class="{'active' : on}" aria-hidden="true" x-state:on="Enabled" x-state:off="Not Enabled">
                 <svg fill="none" viewBox="0 0 12 12">
                     <path d="M4 8l2-2m0 0l2-2M6 6L4 4m2 2l2 2" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                 </svg>
              </span>

              <span :class="{ 'active': on }" aria-hidden="true" x-state:on="Enabled" x-state:off="Not Enabled">
                  <svg fill="currentColor" viewBox="0 0 12 12">
                      <path d="M3.707 5.293a1 1 0 00-1.414 1.414l1.414-1.414zM5 8l-.707.707a1 1 0 001.414 0L5 8zm4.707-3.293a1 1 0 00-1.414-1.414l1.414 1.414zm-7.414 2l2 2 1.414-1.414-2-2-1.414 1.414zm3.414 2l4-4-1.414-1.414-4 4 1.414 1.414z"></path>
                  </svg>
              </span>
            </span>
        </button>
    </div>
    <?php if (isset($labelRight)): ?>
        <label
            class="form-label cursor-pointer select-none !mb-0"
            @click="handleToggle(async () => { <?php echo isset($action) ? $action : null ?> })"
        >
            <?php echo $labelRight; ?>
        </label>
    <?php endif; ?>
</div>